% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GraphicsSPBal.R
\name{GraphicsSPBal}
\alias{GraphicsSPBal}
\title{Obtaining the graphic of the SPBal at all time points}
\usage{
GraphicsSPBal(MatrizPBmodelo)
}
\arguments{
\item{MatrizPBmodelo}{Matrix. Output of "ObtainigValueSPBal" function.  MatrixSPBal is the matrix that contains the covariates of the model. The first line es equal to 1 for all columns. The other rows contain the value of one SPBal at all time points. The selected principal balance of the row i+1 has at its numerator the bacteria placed in the rows \code{NumSPBal[[i]]} of the "especie". The selected principal balance of the row i+1 has at its denominator the bacteria placed in the rows \code{DemSPBal[[i]]} of the "especie".}
}
\value{
Returns a graphic.
}
\description{
The SPBal (of BPBM model) are ordered from highest to lowest variance percentage. The zero is highlight because the closer the value of the balance is to zero, the more similar (in terms of relative abundance) the numerator and denominator groups will be. The farther away from zero, the more different.
}
\examples{

MatrizPBmodelo=rbind(c(1,1,1,1,1,1),c(-0.3,0.4,0.3,-0.7,-0.4,-0.6),c(0.3,0.5,-0.3,0.1,0.4,0.1))
GraphicsSPBal(MatrizPBmodelo)

}
\references{
Creus-Martí, I., Moya, A., Santonja, F. J. (2022). Bayesian hierarchical compositional models for analysing longitudinal abundance data from microbiome studies. Complexity, 2022.
}
