% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot2.R
\name{plot.CoDiNA}
\alias{plot.CoDiNA}
\title{plot.CoDiNA}
\usage{
\method{plot}{CoDiNA}(x, cutoff.external = 0.8, cutoff.internal = 0.5,
  layout = NULL, smooth.edges = TRUE, path = NULL, MakeGroups = FALSE,
  Cluster = FALSE, legend = TRUE, manipulation = FALSE,
  sort.by.Phi = FALSE, ...)
}
\arguments{
\item{x}{Output from MakeDiffNet}

\item{cutoff.external}{The cut-off between the clusters (delta from the center to the edge coordinates), the closer to 1, the better.}

\item{cutoff.internal}{The cut-off inside the clusters (delta from the theoretical cluster to the edge coordinates), the closer to zero, the better.}

\item{layout}{a layout from the igraph package.}

\item{smooth.edges}{If the edges should be smoothed or not.}

\item{path}{If the graph should be saved specify the name of the file.}

\item{MakeGroups}{algorithm to find clusters. One of the followings: walktrap, optimal, spinglass, edge.betweenness, fast_greedy, infomap, louvain, label_prop, leading_eigen. Default to FALSE.}

\item{Cluster}{TRUE or FALSE if the nodes should be clustered (double click to uncluster).}

\item{legend}{TRUE or FALSE if the legend should appear.}

\item{manipulation}{TRUE or FALSE if the graph should be editable.}

\item{sort.by.Phi}{if the graph should be plotted in the Phi order}

\item{\dots}{Additional plotting parameters.}
}
\value{
Returns a list contatining: The nodes description, the Edges description and the network graph.
}
\description{
Categorize the Nodes into Phi and groups categories. Also, creates an interactive view of the CoDiNA network.
}
\examples{
Nodes = LETTERS[1:10]
Net1 = data.frame(Node.1 = sample(Nodes) , Node.2 = sample(Nodes), wTO = runif(10,-1,1))
Net2 = data.frame(Node.1 = sample(Nodes) , Node.2 = sample(Nodes), wTO = runif(10,-1,1))
Net3 = data.frame(Node.1 = sample(Nodes) , Node.2 = sample(Nodes), wTO = runif(10,-1,1))
DiffNet = MakeDiffNet (Data = list(Net1,Net2,Net3), Code = c('Net1', 'Net2', 'Net3') )
Graph = plot(x = DiffNet,
 layout = NULL, smooth.edges = TRUE,
 path = NULL, MakeGroups = FALSE, Cluster = FALSE,
 legend = TRUE, manipulation = FALSE, sort.by.Phi = FALSE)
Graph

}
\author{
Deisy Morselli Gysi <deisy at bioinf.uni-leipzig.de>
}
