% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stcs.r
\name{stcfclayton}
\alias{stcfclayton}
\title{Clayton SpatioTemporal Correlation Structure}
\usage{
stcfclayton(t, s, scfid, tcfid, copulaarg, scfarg, tcfarg)
}
\arguments{
\item{t}{time lag}

\item{s}{spatial lag (distance)}

\item{scfid}{ID of the spatial (marginal) correlation structure (e.g. weibull)}

\item{tcfid}{ID of the temporal (marginal) correlation structure (e.g. weibull)}

\item{copulaarg}{parameter of the Clayton copula linking the marginal correlation structures}

\item{scfarg}{parameters of spatial (marginal) correlation structure}

\item{tcfarg}{parameters of temporal (marginal) correlation structure}
}
\description{
Provides spatiotemporal correlation structure function based on Clayton copula. For more details on the parametric spatiotemporal correlation structures see section 2.3 and 2.4 in \href{https://doi.org/10.1029/2019WR026331}{Papalexiou and Serinaldi (2020)}
}
\examples{

library(CoSMoS)
library(plotly)

## specify grid of spatial and temporal lags
d <- 31
st <- expand.grid(0:(d - 1),
                  0:(d - 1))

## get the STCS
wc <- stcfclayton(t = st[, 1],
                  s = st[, 2],
                  scfid = 'weibull',
                  tcfid = 'weibull',
                  copulaarg = 2,
                  scfarg = list(scale = 20,
                                shape = 0.7),
                  tcfarg = list(scale = 1.1,
                                shape = 0.8))

## visualize the STCS
wc.m <- matrix(wc,
               nrow = d)

plot_ly(z = ~wc.m) \%>\%
    add_surface() \%>\%
    layout(
        scene = list(
            xaxis = list(title = "Time lag"),
            yaxis = list(title = "Distance"),
            zaxis = list(title = "STCF")
        )
    ) \%>\%
    hide_colorbar()

}
