% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableCohortTiming.R
\name{tableCohortTiming}
\alias{tableCohortTiming}
\title{Format a summariseCohortTiming result into a visual table.}
\usage{
tableCohortTiming(
  result,
  timeScale = "days",
  type = "gt",
  formatEstimateName = c(N = "<count>", `Median [Q25 - Q75]` =
    "<median> [<q25> - <q75>]", Range = "<min> - <max>"),
  header = c("strata"),
  split = c("group", "strata", "additional"),
  groupColumn = NULL,
  excludeColumns = c("result_id", "estimate_type", "variable_level"),
  .options = list()
)
}
\arguments{
\item{result}{A summariseCohortTiming result}

\item{timeScale}{Time scale to plot results. Can be days or years.}

\item{type}{Type of desired formatted table, possibilities: "gt",
"flextable", "tibble".}

\item{formatEstimateName}{Named list of estimate name's to join, sorted by
computation order. Indicate estimate_name's between <...>.}

\item{header}{A vector containing which elements should go into the header
in order. Allowed are: `cdm_name`, `group`, `strata`, `additional`,
`variable`, `estimate`, `settings`.}

\item{split}{A vector containing the name-level groups to split ("group",
"strata", "additional"), or an empty character vector to not split.}

\item{groupColumn}{Column to use as group labels.}

\item{excludeColumns}{Columns to drop from the output table.}

\item{.options}{named list with additional formatting options.
CohortCharacteristics::optionsTableCohortTiming() shows allowed arguments and
their default values.}
}
\value{
A formatted table of the summariseCohortTiming result.
}
\description{
`r lifecycle::badge("experimental")`
}
