% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conceptCohort.R
\name{conceptCohort}
\alias{conceptCohort}
\title{Create cohorts based on a concept set}
\usage{
conceptCohort(cdm, conceptSet, name)
}
\arguments{
\item{cdm}{A cdm reference.}

\item{conceptSet}{A conceptSet, which can either be a codelist
or a conceptSetExpression.}

\item{name}{Name of the cohort in the cdm object.}
}
\value{
A cohort table
}
\description{
Create cohorts based on a concept set
}
\examples{
\donttest{
library(CohortConstructor)

cdm <- mockCohortConstructor(conditionOccurrence = TRUE)

cohort <- conceptCohort(cdm = cdm, conceptSet = list(a = 1), name = "cohort")

cohort |> attrition()
}
}
