% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Help_Func.R
\name{age_save}
\alias{age_save}
\title{Export Brain ROI Age Trends}
\usage{
age_save(path, age_list)
}
\arguments{
\item{path}{The path to save the excel file.}

\item{age_list}{A list containing all ROIs' true volumes, age trend estimates, and the fitted GAMLSS model.}
}
\value{
This function does not return a value. It saves the data to the specified file.
}
\description{
Save all brain age trends into a single Excel file.
}
\examples{
if(interactive()){
sub_df <- age_df[,c("Volume_1", "age", "sex", "ICV_baseline")] |> na.omit()
colnames(sub_df) <- c("Volume_1", "age", "sex", "icv")
age_list <- list("Volume_1" = age_list_gen(sub_df = sub_df))

temp_dir <- tempfile()
dir.create(temp_dir)
age_save(temp_dir, age_list)
message("Age trend table saved to: ", temp_dir)
unlink(temp_dir, recursive = TRUE)
}
\dontshow{
if (exists("temp_dir")) unlink(temp_dir, recursive = TRUE)
}
}
