/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class TranslatingShape
implements Shape {
    private Shape shape;
    private double dx;
    private double dy;

    public TranslatingShape(Shape shape, double d, double d2) {
        this.shape = shape;
        this.dx = d;
        this.dy = d2;
    }

    public Rectangle getBounds() {
        Rectangle rectangle = this.shape.getBounds();
        rectangle.translate((int)this.dx, (int)this.dy);
        return rectangle;
    }

    public Rectangle2D getBounds2D() {
        Rectangle2D rectangle2D = this.shape.getBounds2D();
        rectangle2D.setRect(rectangle2D.getMinX() + this.dx, rectangle2D.getMinY() + this.dy, rectangle2D.getWidth(), rectangle2D.getHeight());
        return rectangle2D;
    }

    public boolean contains(double d, double d2) {
        return this.shape.contains(d - this.dx, d2 - this.dy);
    }

    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        return this.shape.intersects(d - this.dx, d2 - this.dy, d3, d4);
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        return this.shape.contains(d - this.dx, d2 - this.dy, d3, d4);
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getMinX() - this.dx, rectangle2D.getMinY() - this.dy, rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new Iterator(this.shape.getPathIterator(affineTransform));
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return new Iterator(this.shape.getPathIterator(affineTransform, d));
    }

    private class Iterator
    implements PathIterator {
        private PathIterator iterator;

        Iterator(PathIterator pathIterator) {
            this.iterator = pathIterator;
        }

        public int getWindingRule() {
            return this.iterator.getWindingRule();
        }

        public boolean isDone() {
            return this.iterator.isDone();
        }

        public void next() {
            this.iterator.next();
        }

        public int currentSegment(float[] fArray) {
            int n = this.iterator.currentSegment(fArray);
            int n2 = 0;
            while (n2 < fArray.length) {
                int n3 = n2++;
                fArray[n3] = (float)((double)fArray[n3] + TranslatingShape.this.dx);
                int n4 = n2++;
                fArray[n4] = (float)((double)fArray[n4] + TranslatingShape.this.dy);
            }
            return n;
        }

        public int currentSegment(double[] dArray) {
            int n = this.iterator.currentSegment(dArray);
            int n2 = 0;
            while (n2 < dArray.length) {
                int n3 = n2++;
                dArray[n3] = dArray[n3] + TranslatingShape.this.dx;
                int n4 = n2++;
                dArray[n4] = dArray[n4] + TranslatingShape.this.dy;
            }
            return n;
        }
    }
}

