/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import net.infonode.util.ArrayUtil;
import net.infonode.util.Readable;
import net.infonode.util.Writable;

public class StreamUtil {
    public static final void readAll(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = inputStream.read(byArray, n, n2);
            if (n3 == -1) {
                throw new IOException("End of stream reached!");
            }
            n += n3;
            n2 -= n3;
        }
    }

    public static final byte[] readAll(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[inputStream.available()];
        for (int i = 0; i < byArray.length; i += inputStream.read(byArray, i, byArray.length - i)) {
        }
        inputStream.close();
        return byArray;
    }

    public static final byte[] writeObject(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.close();
        return ArrayUtil.part(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
    }

    public static final Object readObject(byte[] byArray) throws IOException, ClassNotFoundException {
        return new ObjectInputStream(new ByteArrayInputStream(byArray)).readObject();
    }

    public static byte[] write(Writable writable) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        writable.write(objectOutputStream);
        objectOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static void read(byte[] byArray, Readable readable) throws IOException {
        readable.read(new ObjectInputStream(new ByteArrayInputStream(byArray)));
    }

    public static void readAll(InputStream inputStream, byte[] byArray) throws IOException {
        StreamUtil.readAll(inputStream, byArray, 0, byArray.length);
    }

    public static void write(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        byte[] byArray = new byte[10000];
        while (n > 0) {
            int n2 = inputStream.read(byArray, 0, Math.min(byArray.length, n));
            outputStream.write(byArray, 0, n2);
            n -= n2;
        }
    }
}

