% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binaryVisualiseR.R
\name{binary_visualiseR}
\alias{binary_visualiseR}
\title{Binary Visualiser - A Binary Confusion Matrix Visual}
\usage{
binary_visualiseR(
  train_labels,
  truth_labels,
  class_label1 = "Class Negative",
  class_label2 = "Class Positive",
  quadrant_col1 = "#3F97D0",
  quadrant_col2 = "#F7AD50",
  custom_title = "Confusion matrix",
  info_box_title = "Confusion matrix statistics",
  text_col = "black",
  round_dig = 2,
  cm_stat_size = 1.4,
  cm_stat_lbl_size = 1.5
)
}
\arguments{
\item{train_labels}{the classification labels from the training set}

\item{truth_labels}{the testing set ground truth labels for comparison}

\item{class_label1}{classification label 1 i.e. readmission into hospital}

\item{class_label2}{classification label 2 i.e. not a readmission into hospital}

\item{quadrant_col1}{colour of the first quadrant - specified as hexadecimal}

\item{quadrant_col2}{colour of the second quadrant - specified as hexadecimal}

\item{custom_title}{title of the confusion matrix plot}

\item{info_box_title}{title of the confusion matrix statistics box}

\item{text_col}{the colour of the text}

\item{round_dig}{rounding options}

\item{cm_stat_size}{the cex size of the statistics box label}

\item{cm_stat_lbl_size}{the cex size of the label in the statistics box}
}
\value{
returns a visual of a Confusion Matrix output
}
\description{
a confusion matrix object for binary classification machine learning problems.
Returns a plot to visualise the important statistics derived from a confusion matrix, see: \url{https://machinelearningmastery.com/confusion-matrix-machine-learning/}.
}
\examples{
library(dplyr)
library(ConfusionTableR)
library(caret)
library(tidyr)
library(mlbench)


# Load in the data
data("BreastCancer", package = "mlbench")
breast <- BreastCancer[complete.cases(BreastCancer), ] #Create a copy
breast <- breast[, -1]
breast <- breast[1:100,]
breast$Class <- factor(breast$Class) # Create as factor
for(i in 1:9) {
 breast[, i] <- as.numeric(as.character(breast[, i]))
}

#Perform train / test split on the data
train_split_idx <- caret::createDataPartition(breast$Class, p = 0.75, list = FALSE)
train <- breast[train_split_idx, ]
test <- breast[-train_split_idx, ]
rf_fit <- caret::train(Class ~ ., data=train, method="rf")
#Make predictions to expose class labels
preds <- predict(rf_fit, newdata=test, type="raw")
predicted <- cbind(data.frame(class_preds=preds), test)
# Create the visual
ConfusionTableR::binary_visualiseR(predicted$class_preds,
predicted$Class, custom_title="Breast Cancer prediction")
}
\keyword{internal}
