% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_cong_data.R
\name{get_cong_data}
\alias{get_cong_data}
\title{Load CongressData into the R environment}
\usage{
get_cong_data(states = NULL, related_to = "", years = NULL)
}
\arguments{
\item{states}{Default is NULL. If left blank, returns all states. Takes a
string or vector of strings of state names.}

\item{related_to}{Default is "". Provide a string to search a variable's name,
short/long descriptions from the codebook, and its citation for non-exact matches o
f a search term. For example, searching 'tax' will return variables with words
like 'taxes' and 'taxable' in any of those columns.}

\item{years}{Default is NULL. If left blank, returns all years Input can be
a single year (e.g. 2001) or a two year that represent the first and last
that you want in the outputted dataframe (such as \code{c(1989, 20001)}).}
}
\value{
An object of type tibble containing CongressData. The tibble has columns corresponding
to variables in the dataset, and rows corresponding to observations that match
the filtering criteria specified by the \code{states}, \code{related_to}, and \code{years} parameters.
}
\description{
\code{get_cong_data} loads either a full or subsetted version of the full
CongressData dataset into the R environment as a dataframe.
}
