% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DECOR.R
\name{DECOR}
\alias{DECOR}
\title{Differential Evolution algorithm for Median Ranking}
\usage{
DECOR(X, Wk = NULL, NP = 15, L = 100, FF = 0.4, CR = 0.9,
  FULL = FALSE)
}
\arguments{
\item{X}{A N by M data matrix, in which there are N judges and M objects to be judged. Each row is a ranking of the objects which are represented by the columns. Alternatively X can contain the rankings observed only once. In this case the argument Wk must be used}

\item{Wk}{Optional: the frequency of each ranking in the data}

\item{NP}{The number of population individuals}

\item{L}{Generations limit: maximum number of consecutive generations without improvement}

\item{FF}{The scaling rate for mutation. Must be in [0,1]}

\item{CR}{The crossover range. Must be in [0,1]}

\item{FULL}{Default FULL=FALSE. If FULL=TRUE, the searching is limited to the space of full rankings.}
}
\value{
a "list" containing the following components:
\tabular{lll}{
Consensus \tab  \tab the Consensus Ranking\cr
Tau \tab       \tab averaged TauX rank correlation coefficient\cr
Eltime\tab   \tab Elapsed time in seconds}
}
\description{
Differential evolution algorithm for median ranking detection. 
It works with full, tied and partial rankings. The solution con be
constrained to be a full ranking or a tied ranking
}
\details{
It works with a very large number of items to be ranked. Empirically, the number
of population individuals (the NP parameter) can be set equal to 10, 20 or 30
for problems till 20, 50 and 100 items. Both scaling rate and crossover ratio (parameters
FF and CR) must be set by the user. The default options (FF=0.4, CR=0.9) work well
for a large variety of data sets
}
\examples{
data(EMD)
CR=DECOR(EMD[,1:15],EMD[,16])

}
\references{
D'Ambrosio, A., Mazzeo, G., Iorio, C., and Siciliano, R. (2017). A differential evolution algorithm for finding the median ranking under the Kemeny axiomatic approach. Computers and Operations Research, vol. 82, pp. 126-138.
}
\seealso{
\code{\link{FASTcons}} FAST algorithm.

\code{\link{QuickCons}} Quick algorithm.

\code{\link{EMCons}} Branch-and-bound algorithm.
}
\author{
Antonio D'Ambrosio \email{antdambr@unina.it} and Giulio Mazzeo \email{giuliomazzeo@gmail.com}
}
\keyword{Differential}
\keyword{Genetic}
\keyword{Median}
\keyword{algorithms}
\keyword{evolution}
\keyword{ranking}
