% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.ranktree.R
\name{plot.ranktree}
\alias{plot.ranktree}
\title{Plot tree-based structure or pruning sequence of ranktree}
\usage{
\method{plot}{ranktree}(
  x,
  plot.type = "tree",
  dispclass = FALSE,
  valtree = NULL,
  taos = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of the class "ranktree"}

\item{plot.type}{One among "tree" or "pruningseq"}

\item{dispclass}{Display the median ranking above terminal nodes. Default option: FALSE}

\item{valtree}{If plot.type="pruningseq", it shows the Tau_x rank correlation coefficient or the error along the pruning sequence on the training set. If valtree is the output of the function \code{validatetree}, it shows either the Tau_x rank correlation coefficient or the error along the pruning sequence of also the decision tree (validated by wither test set or cross-validation)}

\item{taos}{If plot.type="pruningseq", it plots the Tau_x rank correlation coefficient along the pruning sequence. If taos=FALSE, it plots the error.}

\item{\dots}{System reserved (No specific usage)}
}
\value{
the plot of either the tree or the pruning sequence
}
\description{
Plot the tree coming from the \code{ranktree} or the pruning sequence of the \code{ranktree}
}
\examples{
data("Univranks")
tree <- ranktree(Univranks$rankings,Univranks$predictors,num=50)
plot(tree,dispclass=TRUE)
  
\donttest{
data(EVS)
EVS$rankings[is.na(EVS$rankings)] <- 3
set.seed(654)
training=sample(1911,1434)
tree <- ranktree(EVS$rankings[training,],EVS$predictors[training,],decrmin=0.001,num=50)
plot(tree,dispclass=TRUE)
#test set validation
vtreetest <- validatetree(tree,testX=EVS$predictors[-training,],EVS$rankings[-training,]) 
dtree <- getsubtree(tree,vtreetest$best_tau)
plot(dtree,dispclass=TRUE)
#see the global weigthted tau_X rank correlation coefficients
plot(tree,plot.type="pruningseq",valtree=vtreetest)
#see the error rates
plot(tree,plot.type="pruningseq",valtree=vtreetest, taos=FALSE)
}

}
\seealso{
\code{\link{ranktree}},  \code{\link{validatetree}}
}
\author{
Antonio D'Ambrosio \email{antdambr@unina.it}
}
\keyword{Tree-based}
\keyword{pruning}
\keyword{sequence}
\keyword{structure}
