% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMinimumWinningCoalitions.R
\name{getMinimumWinningCoalitions}
\alias{getMinimumWinningCoalitions}
\alias{getMinimalWinningCoalitions}
\title{Compute minimal winning coalitions in a simple game}
\usage{
getMinimumWinningCoalitions(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
A data frame containing all minimum winning coalitions for a simple game.
}
\description{
The function getMinimumWinningCoalitions identifies 
all minimal winning coalitions of a specified simple game.
These coalitions are characterized by the circumstance that 
if any player breaks away from them, then the coalition
generates no value (then also called a losing coalition) - all players
in the coalition can therefore be described as critical players.
}
\examples{
library(CoopGame)
getMinimumWinningCoalitions(v=c(0,0,0,0,0,0,1))

\donttest{
library(CoopGame)
v=weightedVotingGameVector(n=3,w=c(1,2,3),q=5)
getMinimumWinningCoalitions(v)
# Output:
#   V1 V2 V3 cVal
# 6  0  1  1    1
# => the coalition containing player 2 and 3 is a minimal winning coalition
}

}
\references{
Deegan J. and  Packel E.W. (1978) "A new index of power for simple n-person games", Int. Journal of Game Theory 7(2), pp. 151--161

Peters H. (2015)  \emph{Game Theory: A Multi-Leveled Approach}, 2nd Edition, Springer, p. 295

Bertini C. (2011) "Minimal winning coalition", Encyclopedia of Power, SAGE Publications, pp. 422--423
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
