% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParameterChecks_CoopGame.R
\name{stopOnInvalidIndex}
\alias{stopOnInvalidIndex}
\title{Parameter Function stopOnInvalidIndex}
\usage{
stopOnInvalidIndex(paramCheckResult, index, n = NULL)
}
\arguments{
\item{paramCheckResult}{list object for check result with list element 'errCode' for the error code
and 'errMessage' for the error message.}

\item{index}{index which is checked to be a valid index}

\item{n}{represents the number of players}
}
\description{
stopOnInvalidIndex checks if coalition function 
(in the form of either v or A) is specified correctly and causes causes calculation 
to stop otherwise.
}
\section{Error Code Ranges}{

Error codes and messages shown to user if error on parameter check occurs
\tabular{lll}{
\strong{Error Code} \tab \strong{Message} \cr
1070 \tab Index is 'NULL'. \cr
1071 \tab Index is 'not numeric'. \cr
1072 \tab Index is within the wrong range according to number of players n.}
}

\examples{
library(CoopGame)
v=c(1:7)
paramCheckResult=getEmptyParamCheckResult()
validIndex = 5
stopOnInvalidIndex(paramCheckResult, index=validIndex, n=3)

}
\seealso{
Other ParameterChecks_CoopGame: \code{\link{getEmptyParamCheckResult}},
  \code{\link{stopOnInconsistentEstateAndClaimsVector}},
  \code{\link{stopOnInvalidAllocation}},
  \code{\link{stopOnInvalidBoolean}},
  \code{\link{stopOnInvalidClaimsVector}},
  \code{\link{stopOnInvalidCoalitionS}},
  \code{\link{stopOnInvalidDictator}},
  \code{\link{stopOnInvalidEstate}},
  \code{\link{stopOnInvalidGameVector}},
  \code{\link{stopOnInvalidGrandCoalitionN}},
  \code{\link{stopOnInvalidLeftRightGloveGame}},
  \code{\link{stopOnInvalidNChooseB}},
  \code{\link{stopOnInvalidNumberOfPlayers}},
  \code{\link{stopOnInvalidNumber}},
  \code{\link{stopOnInvalidQuota}},
  \code{\link{stopOnInvalidVetoPlayer}},
  \code{\link{stopOnInvalidWeightVector}},
  \code{\link{stopOnParamCheckError}}
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}

Johannes Anwander \email{anwander.johannes@gmail.com}
}
\concept{ParameterChecks_CoopGame}
