% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deg_rationet.R
\name{netDEG}
\alias{netDEG}
\title{netDEG: Differentially expressed gene identification method}
\usage{
netDEG(ref.expr.matrix, expr.matrix, p.edge = 0.1,
  summarize = c("gene", "sample"), log.expr = FALSE,
  use.parallel = FALSE)
}
\arguments{
\item{ref.expr.matrix}{The reference expression matrix. Each row represents a gene and each column represents a sample.}

\item{expr.matrix}{The test expression matrix. Each row represents a gene and each column represents a sample.}

\item{p.edge}{The expected probability of edges in the expression ratio network for a normal sample.}

\item{summarize}{Character vector indicating how to summarize the results. Available methods are \code{c("gene", "sample")}.}

\item{log.expr}{Logical variable indicating whether the input expression matrix is in logarithmic scale.}

\item{use.parallel}{Logical variable indicating to use the BiocParallel package to accelerate computation.}
}
\value{
This function will return a list with the following components:
  \item{up}{A numeric matrix with same dimension as \code{expr.matrix}, containing the p-values of up-regulation test.}
  \item{down}{A numeric matrix with same dimension as \code{expr.matrix}, containing the p-values of down-regulation test.}
  \item{twoside}{A numeric matrix with same dimension as \code{expr.matrix}, containing the p-values of twoside test.}
  \item{gene}{A list containing the gene-wise summaried results, containing three components: \code{up}, \code{down}, 
  and \code{twoside}. Available if the corresponding method is specified in \code{summarize} argument.}
  \item{sample}{A list containing the sample-wise summaried results, containing three components: \code{up}, \code{down},
  and \code{twoside}. Available if the corresponding method is specified in \code{summarize} argument.}
}
\description{
Perform netDEG for two group samples.
}
