% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomForest.R
\name{randomForest}
\alias{randomForest}
\title{Random Forest}
\usage{
randomForest(dataset = cs.in.dataset(), preds = cs.in.predictors(),
  resps = cs.in.responses(), brush = cs.in.brushed(),
  scriptvars = cs.in.scriptvars(), return.results = FALSE,
  num.threads = NULL)
}
\arguments{
\item{dataset}{[\code{\link{data.frame}}]\cr
Dataset with named columns. The names correspond to predictors and responses.}

\item{preds}{[\code{character}]\cr
Character vector of predictors.}

\item{resps}{[\code{character}]\cr
Character vector of responses.}

\item{brush}{[\code{logical}]\cr
Logical vector of length \code{nrow(dataset)}.
Flags brushed rows in Cornerstone.}

\item{scriptvars}{[\code{list}]\cr
Named list of script variables set via the Cornerstone "Script Variables" menu.
\code{NULL} invokes the default values.
See below for details.}

\item{return.results}{[\code{logical(1)}]\cr
If \code{FALSE} the function returns \code{TRUE} invisibly.
If \code{TRUE}, it returns a \code{\link{list}} of results.
Default is \code{FALSE}.}

\item{num.threads}{[\code{integer(1)}]\cr
Number of threads as described in \code{\link[ranger]{ranger}}\cr
Default is \code{NULL}.}
}
\value{
Logical [\code{TRUE}] invisibly or, if \code{return.results = TRUE}, \code{\link{list}} of 
  resulting \code{\link{data.frame}} objects:
  \item{statistics}{General statistics of random forest.}
  \item{importances}{
    Variable importances of prediction variables in descending order of importance
    (most important first)
  }
  \item{predictions}{
    Brushable dataset with predicted values for \code{dataset}. The original input and other
    columns can be added to this dataset through the menu \code{Columns -> Add from Parent ...}.
  }
  \item{confusion}{
    For categorical response variables or brush state only. A table with counts of each 
    distinct combination of predicted and actual values.
  }
}
\description{
Random Forest via \code{\link[ranger]{ranger}}. Predicts response variables or brushed set of 
  rows from predictor variables, using Random Forest classification or regression.
}
\details{
Three script variables are summarized in \code{scriptvars} list:\cr
  \describe{
    \item{brush.pred}{[\code{logical(1)}]\cr
      Use \code{brush} vector as additional predictor.\cr
      Default is \code{FALSE}.}
    \item{use.rows}{[\code{character(1)}]\cr
      Rows to use in model fit. Possible values are \code{all}, \code{unbrushed}, or 
      \code{brushed}.\cr
      Default is \code{all}.}
    \item{num.trees}{[\code{integer(1)}]\cr
      Number of trees to fit in \code{\link[ranger]{ranger}}.\cr
      Default is \code{500}.}
  }
}
\examples{
# Fit random forest to iris data:
res = randomForest(iris, c("Sepal.Length", "Sepal.Width", "Petal.Length", "Petal.Width"), "Species"
                   , brush = rep(FALSE, nrow(iris)), return.results = TRUE
                   )
# Show general statistics:
res$statistics
}
