% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelFit.R
\name{fitCyclopsModel}
\alias{fitCyclopsModel}
\title{Fit a Cyclops model}
\usage{
fitCyclopsModel(
  cyclopsData,
  prior = createPrior("none"),
  control = createControl(),
  weights = NULL,
  forceNewObject = FALSE,
  returnEstimates = TRUE,
  startingCoefficients = NULL,
  fixedCoefficients = NULL,
  computeDevice = "native"
)
}
\arguments{
\item{cyclopsData}{A Cyclops data object}

\item{prior}{A prior object. More details are given below.}

\item{control}{A \code{"cyclopsControl"} object constructed by \code{\link{createControl}}}

\item{weights}{Vector of 0/1 weights for each data row}

\item{forceNewObject}{Logical, forces the construction of a new Cyclops model fit object}

\item{returnEstimates}{Logical, return regression coefficient estimates in Cyclops model fit object}

\item{startingCoefficients}{Vector of starting values for optimization}

\item{fixedCoefficients}{Vector of booleans indicating if coefficient should be fix}

\item{computeDevice}{String: Name of compute device to employ; defaults to \code{"native"} C++ on CPU}
}
\value{
A list that contains a Cyclops model fit object pointer and an operation duration
}
\description{
\code{fitCyclopsModel} fits a Cyclops model data object
}
\details{
This function performs numerical optimization to fit a Cyclops model data object.
}
\section{Prior}{

Currently supported prior types are:
\tabular{ll}{
	\verb{	"none"} \tab Useful for finding MLE \cr
	\verb{	"laplace"} \tab L_1 regularization \cr
 \verb{  "normal"} \tab L_2 regularization \cr
}
}

\examples{
## Dobson (1990) Page 93: Randomized Controlled Trial :
counts <- c(18,17,15,20,10,20,25,13,12)
outcome <- gl(3,1,9)
treatment <- gl(3,3)
cyclopsData <- createCyclopsData(counts ~ outcome + treatment, modelType = "pr")
cyclopsFit <- fitCyclopsModel(cyclopsData, prior = createPrior("none"))
coef(cyclopsFit)
confint(cyclopsFit, c("outcome2","treatment3"))
predict(cyclopsFit)

}
\references{
Suchard MA, Simpson SE, Zorych I, Ryan P, Madigan D.
Massive parallelization of serial inference algorithms for complex generalized linear models.
ACM Transactions on Modeling and Computer Simulation, 23, 10, 2013.

Simpson SE, Madigan D, Zorych I, Schuemie M, Ryan PB, Suchard MA.
Multiple self-controlled case series for large-scale longitudinal observational databases.
Biometrics, 69, 893-902, 2013.

Mittal S, Madigan D, Burd RS, Suchard MA.
High-dimensional, massive sample-size Cox proportional hazards regression for survival analysis.
Biostatistics, 15, 207-221, 2014.
}
