% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/populations.R
\docType{methods}
\name{populations}
\alias{populations}
\alias{populations.list}
\alias{populations.list,UserSession-method}
\alias{populations.show}
\alias{populations.show,UserSession-method}
\title{Population Endpoints}
\usage{
\S4method{populations.list}{UserSession}(UserSession, experiment_id,
  output = "default", timeout = UserSession@short_timeout)

\S4method{populations.show}{UserSession}(UserSession, experiment_id,
  population_id, output = "default", timeout = UserSession@short_timeout)
}
\arguments{
\item{UserSession}{Cytobank UserSession object}

\item{experiment_id}{integer representing an \link[=experiments]{experiment} ID}

\item{output}{character representing the output format \strong{[optional]}\cr
\emph{- populations.list, populations.show : \code{("default", "raw")}}}

\item{timeout}{integer representing the request timeout time in seconds}

\item{population_id}{integer representing a population ID}
}
\description{
Interact with population (aka gate sets) endpoints. A population is a set of \link[=gates]{gates} and can have parents and children. \href{https://support.cytobank.org/hc/en-us/articles/204765578-The-Difference-Between-a-Gate-and-a-Population-Using-the-Population-Manager-and-considerations-for-deleting-and-renaming-gates}{Learn more about gates and populations}.
}
\details{
\code{populations.list} List all populations from an experiment. Outputs a dataframe [default] or raw list with all fields present.\cr
\emph{- Optional output parameter, specify one of the following: \code{("default", "raw")}}

\code{populations.show} Show population details from an experiment.
\emph{- Optional output parameter, specify one of the following: \code{("default", "raw")}}
}
\examples{
\donttest{# Authenticate via username/password
cyto_session <- authenticate(site="premium", username="cyril_cytometry", password="cytobank_rocks!")
# Authenticate via auth_token
cyto_session <- authenticate(site="premium", auth_token="my_secret_auth_token")
}
\donttest{# Dataframe of all populations with all fields present
populations.list(cyto_session, 22)

# Raw list of all populations with all fields present
populations.list(cyto_session, 22, output="raw")
}
\donttest{populations.show(cyto_session, 22, population_id=2)
}
}

