% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autogating.R
\name{autogating}
\alias{autogating}
\alias{autogating.list_autogating_analyses_of_type,UserSession-method}
\alias{autogating.list_autogating_analyses_of_type}
\alias{autogating.show_autogating_analysis_details,UserSession-method}
\alias{autogating.show_autogating_analysis_details}
\alias{autogating.create_autogating_analysis,UserSession-method}
\alias{autogating.create_autogating_analysis}
\alias{autogating.update_autogating_training_analysis_details,UserSession-method}
\alias{autogating.update_autogating_training_analysis_details}
\alias{autogating.update_autogating_inference_analysis_details,UserSession-method}
\alias{autogating.update_autogating_inference_analysis_details}
\alias{autogating.delete_autogating_analysis,UserSession-method}
\alias{autogating.delete_autogating_analysis}
\alias{autogating.copy_autogating_analysis_settings,UserSession-method}
\alias{autogating.copy_autogating_analysis_settings}
\alias{autogating.rename_autogating_analysis,UserSession-method}
\alias{autogating.rename_autogating_analysis}
\alias{autogating.run_autogating_analysis,UserSession-method}
\alias{autogating.run_autogating_analysis}
\alias{autogating.show_autogating_analysis_status,UserSession-method}
\alias{autogating.show_autogating_analysis_status}
\title{Automatic gating Endpoints}
\usage{
\S4method{autogating.list_autogating_analyses_of_type}{UserSession}(
  UserSession,
  experiment_id,
  analysis_type,
  output = "default",
  timeout = UserSession@long_timeout
)

\S4method{autogating.show_autogating_analysis_details}{UserSession}(
  UserSession,
  experiment_id,
  analysis_id,
  output = "default",
  timeout = UserSession@long_timeout
)

\S4method{autogating.create_autogating_analysis}{UserSession}(
  UserSession,
  experiment_id,
  analysis_type,
  name,
  output = "default",
  timeout = UserSession@long_timeout
)

\S4method{autogating.update_autogating_training_analysis_details}{UserSession}(
  UserSession,
  experiment_id,
  analysis_id,
  createBlindTestExperiment,
  desiredEventsPerFile,
  desiredTotalEvents,
  eventSamplingMethod,
  fcsFileIds,
  gateSetIds,
  learningMagnification,
  optimalClusters,
  randomSeed,
  output = "default",
  timeout = UserSession@long_timeout
)

\S4method{autogating.update_autogating_inference_analysis_details}{UserSession}(
  UserSession,
  experiment_id,
  analysis_id,
  cloneGatesFromParent,
  fcsFileIds,
  trainedModelAnalysisId,
  output = "default",
  timeout = UserSession@long_timeout
)

\S4method{autogating.delete_autogating_analysis}{UserSession}(
  UserSession,
  experiment_id,
  analysis_id,
  timeout = UserSession@long_timeout
)

\S4method{autogating.copy_autogating_analysis_settings}{UserSession}(
  UserSession,
  experiment_id,
  analysis_id,
  output = "default",
  timeout = UserSession@long_timeout
)

\S4method{autogating.rename_autogating_analysis}{UserSession}(
  UserSession,
  experiment_id,
  analysis_id,
  name,
  output = "default",
  timeout = UserSession@long_timeout
)

\S4method{autogating.run_autogating_analysis}{UserSession}(
  UserSession,
  experiment_id,
  analysis_id,
  output = "default",
  timeout = UserSession@long_timeout
)

\S4method{autogating.show_autogating_analysis_status}{UserSession}(
  UserSession,
  experiment_id,
  analysis_id,
  output = "default",
  timeout = UserSession@long_timeout
)
}
\arguments{
\item{UserSession}{Cytobank UserSession object}

\item{experiment_id}{integer representing an \link[=experiments]{experiment} ID}

\item{analysis_type}{character representing the type of ananlysis: auto_gate_train or auto_gate_inference}

\item{output}{character representing the output format \strong{[optional]}\cr
\emph{- drop.upload : \code{("default", "raw")}}\cr
\emph{- \code{dataframe}: converts the file internal compensation matrix output to a dataframe}}

\item{timeout}{integer representing the request timeout time in seconds \strong{[optional]}}

\item{analysis_id}{integer representing the id of an autogating analysis}

\item{name}{character representing the name of an autogating analysis}

\item{createBlindTestExperiment}{boolean A child experiment will be automatically created,
containing the subset of FCS files that were assigned to the blind test set.
For every predicted population, the files now contain one additional
parameter following the naming convention of auto_gate_Population name.}

\item{desiredEventsPerFile}{integer Only applies if eventSamplingMethod is set to equal. Defaults to 50,000.
It is the number of desired events to sample per file, but if the selected
population for any selected file has less total events than the specified number,
that quantity will be used instead.}

\item{desiredTotalEvents}{integer Only applies if eventSamplingMethod is set to proportional. Defaults to 5,000,000.
Represents the total desired number of events to sample amongst all selected files,
whilst keeping the numbers per file proportional to the total number of events in
the selected population for that file. If any file has less events in the selected
population than possible to make a perfectly proportional sampling to add up to the
desired total, all of the events in the file will be used instead.}

\item{eventSamplingMethod}{character Valid options are proportional, equal, or all. Defaults to equal.
If eventSamplingMethod is set to all, all events for the selected population
from all selected files will be used, without any further subsampling.}

\item{fcsFileIds}{vector/list representing the id list of FCS files}

\item{gateSetIds}{vector/list representing the id list of Cytobank gate set}

\item{learningMagnification}{integer By increasing the magnification, the user can determine how many different
models are being trained using different parameters on the same training data.
The model with the highest KPI will be returned to the user.
With a magnification greater than 1, you may be able to influence the model
selection to return a model performing better on your population of interest,
but usually not significant. Of note, increasing the magnification also causes
a proportional increase of the runtime. It may also cause the run to crash
due to memory constraints if there are millions of events.}

\item{optimalClusters}{integer The best estimate of the number of distinct groups of files amongst those selected.
Usually, this aligns with how you would sample tag your files into different
conditions or time points. It helps the algorithm pick representative samples and
perform better. There is an option to create an experiment with blind test files and
their inferred populations. It can make it easier to visually evaluate model
performance.}

\item{randomSeed}{integer Accepts a positive integer value and sets a specific random seed to that value.
If this parameter is not specified or set to 0, autoSeed will automatically be set to true,
and a seed value will be randomly chosen, so that afterward it can be referred to for
reproducing the analysis results.}

\item{cloneGatesFromParent}{boolean The created child experiment will contain a copy of all gates & populations
already present in the parent experiment}

\item{trainedModelAnalysisId}{character The ID of the Autogate Training analysis that contains the model that
the inference run will use.}
}
\description{
Automatic gating Endpoints
}
\details{
\code{autogating.list_autogating_analyses_of_type}

\code{autogating.show_autogating_analysis_details}

\code{autogating.create_autogating_analysis} Create a new automatic gating analysis of
                                                      the specified type (auto_gate_train or auto_gate_inference).

\code{autogating.update_autogating_training_analysis_details}

\code{autogating.update_autogating_inference_analysis_details}

\code{autogating.delete_autogating_analysis}

\code{autogating.copy_autogating_analysis_settings}

\code{autogating.rename_autogating_analysis}

\code{autogating.run_autogating_analysis}

\code{autogating.show_autogating_analysis_status}
}
\examples{
\dontrun{
# Create train analysis
autogating_train_analysis <- autogating.list_autogating_analyses_of_type(cyto_session,
                             p_experiment_id,
                             "auto_gate_train")
# Update train settings
autogating.update_autogating_training_analysis_details(cyto_session, p_experiment_id,
                    autogating_train_analysis$id,
                    FALSE, 39139, 100001, "proportional",
                    c(114386,114373,114383,114374,114384,114387,114385,114377,114382,114375),
                    c(4,3,1,11,10), 1, 2, 1)
# Run analysis
autogating.run_autogating_analysis(cyto_session, p_experiment_id, autogating_train_analysis$id)
# Create inference analysis
autogating_inference_analysis <- autogating.list_autogating_analyses_of_type(cyto_session,
                                            p_experiment_id,
                                            "auto_gate_inference")
# Update inference settings
autogating.update_autogating_inference_analysis_details(cyto_session, p_experiment_id,
                                    autogating_inference_analysis$id, FALSE,
                                    c(114376,114378,114379,114380,114381,114388,114389,114390),
                                    autogating_train_analysis$id)
# Run analysis
autogating.run_autogating_analysis(cyto_session, p_experiment_id,
                                   autogating_inference_analysis$id)
}
\dontrun{autogating.list_autogating_analyses_of_type(cyto_session, 22, "auto_gate_train")
}
\dontrun{autogating.show_autogating_analysis_details(cyto_session, 22, 10)
}
\dontrun{autogating.create_autogating_analysis(cyto_session, 22, "auto_gate_train",
                                                        "My auto gating train analysis")
}
\dontrun{autogating.update_autogating_training_analysis_details(
                                         cyto_session, 22, 10, FALSE, 5000, 100000,
                                         "proportional",
                                         c(10, 11, 12, 13, 14, 15, 16, 17, 18, 19),
                                         c(3, 4), 1, 2, NULL)
}
\dontrun{autogating.update_autogating_inference_analysis_details(
                                      cyto_session, 22, 10, FALSE, c(21, 22, 23), 10)
}
\dontrun{autogating.delete_autogating_analysis(cyto_session, 22, 10)
}
\dontrun{autogating.copy_autogating_analysis_settings(cyto_session, 22, 10)
}
\dontrun{autogating.rename_autogating_analysis(cyto_session, 22, 10, "New new of analysis")
}
\dontrun{autogating.run_autogating_analysis(cyto_session, 22, 10)
}
\dontrun{autogating.show_autogating_analysis_status(cyto_session, 22, 10)
}
}
