% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.ExecutedModels.R
\name{ExecutedModels}
\alias{ExecutedModels}
\title{Handles training of M.L. models}
\description{
Allows to manage the executed M.L. models.
}
\seealso{
\code{\link{Model}}
}
\keyword{error}
\keyword{internal}
\keyword{methods}
\keyword{misc}
\keyword{utilities}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ExecutedModels$new()}}
\item \href{#method-getNames}{\code{ExecutedModels$getNames()}}
\item \href{#method-getBest}{\code{ExecutedModels$getBest()}}
\item \href{#method-add}{\code{ExecutedModels$add()}}
\item \href{#method-exist}{\code{ExecutedModels$exist()}}
\item \href{#method-size}{\code{ExecutedModels$size()}}
\item \href{#method-save}{\code{ExecutedModels$save()}}
\item \href{#method-delete}{\code{ExecutedModels$delete()}}
\item \href{#method-clone}{\code{ExecutedModels$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Method for initializing the object arguments during runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExecutedModels$new(dir.path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dir.path}}{The location were the executed models will be saved.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getNames"></a>}}
\if{latex}{\out{\hypertarget{method-getNames}{}}}
\subsection{Method \code{getNames()}}{
The function is used to obtain the name of the ML model
achieved the best performance during training stage.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExecutedModels$getNames()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{character} vector of length 1 of \link{NULL}
if no ML model have been trained.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getBest"></a>}}
\if{latex}{\out{\hypertarget{method-getBest}{}}}
\subsection{Method \code{getBest()}}{
The function is responsible of returning the model achieving
the best performance value during training stage.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExecutedModels$getBest()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{\link{Model}} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add"></a>}}
\if{latex}{\out{\hypertarget{method-add}{}}}
\subsection{Method \code{add()}}{
The function inserts a new model to the list of executed
models.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExecutedModels$add(model, keep.best = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{A previously trained model (in \code{\link{Model}} object).}

\item{\code{keep.best}}{A \link{logical} value to define the saving operation.
If \link{TRUE} only saves the best model, otherwise all executed models
are saved.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-exist"></a>}}
\if{latex}{\out{\hypertarget{method-exist}{}}}
\subsection{Method \code{exist()}}{
The function is used to discern if a specific model has been
executed previously.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExecutedModels$exist(model.name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model.name}}{A \link{character} vector with the name of the
model to check for existence.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{logical} value. \link{TRUE} if the model exists
and \link{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-size"></a>}}
\if{latex}{\out{\hypertarget{method-size}{}}}
\subsection{Method \code{size()}}{
The function is used to compute the number of executed ML
models.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExecutedModels$size()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{numeric} vector or size 1.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-save"></a>}}
\if{latex}{\out{\hypertarget{method-save}{}}}
\subsection{Method \code{save()}}{
The function is responsible of saving the information of all
executed models into a hidden file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExecutedModels$save()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-delete"></a>}}
\if{latex}{\out{\hypertarget{method-delete}{}}}
\subsection{Method \code{delete()}}{
The function removes an specific model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExecutedModels$delete(model.name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model.name}}{A \link{character} vector with the name of the
model to be removed.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExecutedModels$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
