% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/clustering.heuristics.MultinformationHeuristic.R
\name{MultinformationHeuristic}
\alias{MultinformationHeuristic}
\title{Feature-clustering based on Mutual Information Computation theory.}
\description{
Performs the feature-clustering using MCC score.
Valid for both bi-class and multi-class problems. Only valid for bi-class
problems.
}
\seealso{
\code{\link{Dataset}}, \code{\link[infotheo]{mutinformation}}
}
\keyword{cluster}
\keyword{manip}
\section{Super class}{
\code{\link[D2MCS:GenericHeuristic]{D2MCS::GenericHeuristic}} -> \code{MultinformationHeuristic}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{MultinformationHeuristic$new()}}
\item \href{#method-heuristic}{\code{MultinformationHeuristic$heuristic()}}
\item \href{#method-clone}{\code{MultinformationHeuristic$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Empty function used to initialize the object arguments in
runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MultinformationHeuristic$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-heuristic"></a>}}
\if{latex}{\out{\hypertarget{method-heuristic}{}}}
\subsection{Method \code{heuristic()}}{
Mutinformation takes two random variables as input and
computes the mutual information in nats according to the entropy
estimator method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MultinformationHeuristic$heuristic(col1, col2, column.names = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{col1}}{A vector/factor denoting a random variable or a data.frame
denoting a random vector where columns contain variables/features and
rows contain outcomes/samples.}

\item{\code{col2}}{An another random variable or random vector (vector/factor or
data.frame).}

\item{\code{column.names}}{An optional \link{character} vector with the names of
both columns.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns the mutual information I(X;Y) in nats.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MultinformationHeuristic$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
