% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.SimpleVoting.R
\name{SimpleVoting}
\alias{SimpleVoting}
\title{Abtract class to define simple voting schemes.}
\description{
Abstract class used as a template to define new customized
simple voting schemes.
}
\seealso{
\code{\link{D2MCS}}, \code{\link{ClassMajorityVoting}},
\code{\link{ClassWeightedVoting}}, \code{\link{ProbAverageVoting}},
\code{\link{ProbAverageWeightedVoting}}, \code{\link{ProbBasedMethodology}},
\code{\link{CombinedVoting}}
}
\keyword{math}
\keyword{methods}
\keyword{models}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SimpleVoting-new}{\code{SimpleVoting$new()}}
\item \href{#method-SimpleVoting-getCutoff}{\code{SimpleVoting$getCutoff()}}
\item \href{#method-SimpleVoting-getFinalPred}{\code{SimpleVoting$getFinalPred()}}
\item \href{#method-SimpleVoting-execute}{\code{SimpleVoting$execute()}}
\item \href{#method-SimpleVoting-clone}{\code{SimpleVoting$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimpleVoting-new"></a>}}
\if{latex}{\out{\hypertarget{method-SimpleVoting-new}{}}}
\subsection{Method \code{new()}}{
Method for initializing the object arguments during runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimpleVoting$new(cutoff = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cutoff}}{A \link{character} vector defining the minimum probability
used to perform a positive classification. If is not defined, 0.5 will be
used as default value.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimpleVoting-getCutoff"></a>}}
\if{latex}{\out{\hypertarget{method-SimpleVoting-getCutoff}{}}}
\subsection{Method \code{getCutoff()}}{
The function obtains the minimum probabilistic value used to
perform a positive classification.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimpleVoting$getCutoff()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{numeric} value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimpleVoting-getFinalPred"></a>}}
\if{latex}{\out{\hypertarget{method-SimpleVoting-getFinalPred}{}}}
\subsection{Method \code{getFinalPred()}}{
The function is used to return the prediction values
computed by a voting strategy.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimpleVoting$getFinalPred(type = NULL, target = NULL, filter = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{A \link{character} to define which type of predictions
should be returned. If not defined all type of probabilities will be
returned. Conversely if 'prob' or 'raw' is defined then computed
'probabilistic' or 'class' values are returned.}

\item{\code{target}}{A \link{character} defining the value of the positive
class.}

\item{\code{filter}}{A \link{logical} value used to specify if only predictions
matching the target value should be returned or not. If \link{TRUE} the
function returns only the predictions matching the target value.
Conversely if \link{FALSE} (by default) the function returns all the
predictions.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{FinalPred} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimpleVoting-execute"></a>}}
\if{latex}{\out{\hypertarget{method-SimpleVoting-execute}{}}}
\subsection{Method \code{execute()}}{
Abstract function used to implement the operation of the
voting scheme.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimpleVoting$execute(predictions, verbose = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{predictions}}{A \code{\link{ClusterPredictions}} object containing
all the predictions achieved for each cluster.}

\item{\code{verbose}}{A \link{logical} value to specify if more verbosity is
needed.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimpleVoting-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SimpleVoting-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimpleVoting$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
