% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_prediction.R
\name{single_prediction}
\alias{single_prediction}
\title{Explanations for a Single Prediction}
\usage{
single_prediction(explainer, observation, ...)
}
\arguments{
\item{explainer}{a model to be explained, preprocessed by the 'explain' function}

\item{observation}{a new observarvation for which predictions need to be explained}

\item{...}{other parameters}
}
\value{
An object of the class 'single_prediction_explainer'.
It's a data frame with calculated average response.
}
\description{
Explanations for a Single Prediction
}
\examples{
library("breakDown")
new.wine <- data.frame(citric.acid = 0.35,
     sulphates = 0.6,
     alcohol = 12.5,
     pH = 3.36,
     residual.sugar = 4.8)

wine_lm_model4 <- lm(quality ~ pH + residual.sugar + sulphates + alcohol, data = wine)
wine_lm_explainer4 <- explain(wine_lm_model4, data = wine, label = "model_4v")
wine_lm_predict4 <- single_prediction(wine_lm_explainer4, observation = new.wine)
wine_lm_predict4

\dontrun{
library("randomForest")
wine_rf_model4 <- randomForest(quality ~ pH + residual.sugar + sulphates + alcohol, data = wine)
wine_rf_explainer4 <- explain(wine_rf_model4, data = wine, label = "model_rf")
wine_rf_predict4 <- single_prediction(wine_rf_explainer4, observation = new.wine)
wine_rf_predict4

library("gbm")
# create a gbm model
model <- gbm(quality ~ pH + residual.sugar + sulphates + alcohol, data = wine,
             distribution = "gaussian",
             n.trees = 1000,
             interaction.depth = 4,
             shrinkage = 0.01,
             n.minobsinnode = 10,
             verbose = FALSE)
 # make an explainer for the model
 explainer_gbm <- explain(model, data = wine)
 # create a new observation
 exp_sgn <- single_prediction(explainer_gbm, observation = new.wine,
              n.trees = 1000)
 exp_sgn
 }

}
