% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_predict_diagnostics.R
\name{plot.predict_diagnostics}
\alias{plot.predict_diagnostics}
\title{Plot Instance Level Residual Diagnostics}
\usage{
\method{plot}{predict_diagnostics}(x, ...)
}
\arguments{
\item{x}{an object with instance level residual diagnostics created with \code{\link{predict_diagnostics}} function}

\item{...}{other parameters}
}
\value{
an \code{ggplot2} object of the class \code{gg}.
}
\description{
Plot Instance Level Residual Diagnostics
}
\examples{
library("ranger")
titanic_glm_model <- ranger(survived ~ gender + age + class + fare + sibsp + parch,
                     data = titanic_imputed)
explainer_glm <- explain(titanic_glm_model,
                         data = titanic_imputed,
                         y = titanic_imputed$survived)
johny_d <- titanic_imputed[24, c("gender", "age", "class", "fare", "sibsp", "parch")]

\dontrun{
pl <- predict_diagnostics(explainer_glm, johny_d, variables = NULL)
plot(pl)

pl <- predict_diagnostics(explainer_glm, johny_d,
                       neighbors = 10,
                       variables = c("age", "fare"))
plot(pl)

pl <- predict_diagnostics(explainer_glm,
                       johny_d,
                       neighbors = 10,
                       variables = c("class", "gender"))
plot(pl)
}

}
