% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBCV_function.r
\name{remove_duplicates}
\alias{remove_duplicates}
\title{Function to remove duplicate samples from the input data}
\usage{
remove_duplicates(data, labels)
}
\arguments{
\item{data}{input clustering results}

\item{labels}{labels of the clustering}
}
\value{
a list of data and labels without duplicates
}
\description{
Function to remove duplicate samples from the input data
}
\examples{

n = 300; noise = 0.05; seed = 1782;
theta <- seq(0, pi, length.out = n / 2)
 x1 <- cos(theta) + rnorm(n / 2, sd = noise)
 y1 <- sin(theta) + rnorm(n / 2, sd = noise)
 x2 <- cos(theta + pi) + rnorm(n / 2, sd = noise)
 y2 <- sin(theta + pi) + rnorm(n / 2, sd = noise)
 X <- rbind(cbind(x1, y1), cbind(x2, y2))
 y <- c(rep(0, n / 2), rep(1, n / 2))

cat("remove_duplicates(X, y) = ")
print(remove_duplicates(X, y))
}
