% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infmutua.R
\name{infmutua}
\alias{infmutua}
\title{Estimation of the Average Mutual Information function}
\usage{
infmutua(x, partitions = ceiling(1.5 + log(length(x))/log(2)),
  lag.max = 20, doplot = TRUE)
}
\arguments{
\item{x}{a numeric vector or time serie.}

\item{partitions}{a non-negative integer denoting the number of grouping of the set's elements into non-empty subsets, in such a way that every element is included in exactly one subset.}

\item{lag.max}{a non-negative integer denoting an upper bound for the reconstruction delay (Default 20).}

\item{doplot}{a logical value denoting if you want to draw a plot \code{TRUE} or not \code{FALSE}.}
}
\value{
The optimum lag which corresponds with the first minimum of the Average Mutual Information function.
}
\description{
This function estimates the Average Mutual Information function considering the argument set selected by the user.
}
\examples{
## The first minimum of the average mutual information
## function is showed by simulating a time series from
## the logistic equation.
data<-logistic.ts(u.min=4,u.max=4,B=100,doplot=FALSE)
ts<-data$`Logistic 100`$time.serie
lag.opt<-infmutua(ts,lag.max=10)
show(lag.opt$MutualInf)
show(lag.opt$FirstMin)
}
\references{
Fraser, A.M., Swinney, H.L. 1986 Independent coordinates for strange attractors from mutual information. Physical Review A 33(2):1134.
}
\author{
Julio E. Sandubete, Lorenzo Escot
}
