% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lyapunov.spec.R
\name{lyapunov.spec}
\alias{lyapunov.spec}
\title{Estimation of the Lyapunov exponent spectrum}
\usage{
lyapunov.spec(x, blocking = c("FULL", "NOVER", "EQS", "BOOT"), B = 100,
  doplot = TRUE)
}
\arguments{
\item{x}{a matrix or data frame containing the partial derivatives of jacobian.}

\item{blocking}{a character denoting if you consider the full sample \code{FULL}, the non-overlapping sample \code{NOVER}, the equally spaced sample \code{EQS} or the bootstrap sample \code{BOOT} (Default \code{FULL}).}

\item{B}{a non-negative integer denoting the number of bootstrap iterations (Default 100).}

\item{doplot}{a logical value denoting if you want to draw a plot \code{TRUE} or not \code{FALSE}. If it is \code{TRUE} shows as many graphs as embedding dimensions have been considered. Each of them represents the evolution of the Lyapunov exponent spectrum values for the whole period considering the blocking method selected by the user (Default \code{TRUE}).}
}
\value{
A list containing the Lyapunov exponent spectrum considering the parameter set selected by the user. The dataset saved by each blocking method are the estimated Lyapunov exponent value, the standard error, the z-test value and the p-value. If the user chooses the non-overlapping sample, the equally spaced sample or the bootstrap sample the mean and median values of the Lyapunov exponent are showed. Also some details about the embedding dimension, the sample size, the block length and the block number are recorded.
}
\description{
This function estimates the Lyapunov exponent spectrum through the QR decomposition method considering the argument set selected by the user.
}
\examples{
## We show below an example considering time series from the
## logistic equation. We have estimated the Lyapunov exponent
## spectrum considering the bootstrap sample for an embedding
## dimension (m=4). First of all, we need to estimates the
## partial derivatives of the jacobian.
data<-logistic.ts(u.min=4,u.max=4,B=100,doplot=FALSE)
ts<-data$`Logistic 100`$time.serie
jacob<-jacobi(ts,M0=4,M1=4,doplot=FALSE)
deriv<-jacob$Jacobian.net
lyapu<-lyapunov.spec(deriv,blocking="BOOT",B=10)
show(lyapu$Exponent)
}
\references{
Ellner, S., Gallant, A., McCaffrey, D., Nychka, D. 1991 Convergence rates and data requirements for jacobian-based estimates of lyapunov exponents from data. Physics Letters A 153(6):357-363.

McCaffrey, D.F., Ellner, S., Gallant, A.R., Nychka, D.W. 1992 Estimating the lyapunov exponent of a chaotic system with nonparametric regression. Journal of the American Statistical Association 87(419):682-695.

Nychka, D., Ellner, S., Gallant, A.R., McCaffrey, D. 1992 Finding chaos in noisy systems. Journal of the Royal Statistical Society 54(2):399-426.

Whang, Y.J., Linton, O. 1999 The asymptotic distribution of nonparametric estimates of the lyapunov exponent for stochastic time series. Journal of Econometrics 91(1):1-42.

Shintani, M., Linton, O. 2004 Nonparametric neural network estimation of Lyapunov exponents and a direct test for chaos. Journal of Econometrics 120(1):1-33.
}
\seealso{
\code{\link{lyapunov.max}}, \code{\link{lyapunov}}
}
\author{
Julio E. Sandubete, Lorenzo Escot
}
