% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm_hP_methods.R
\name{AIC}
\alias{AIC}
\alias{AIC.glm_hP}
\alias{BIC.glm_hP}
\title{AIC and BIC for hyper-Poisson Fits}
\usage{
\method{AIC}{glm_hP}(object, ..., k = 2)

\method{BIC}{glm_hP}(object, ...)
}
\arguments{
\item{object}{an object of class \code{"glm_hP"}, typically the result of a
call to \code{\link{glm.hP}}.}

\item{...}{optionally more fitted model objects.}

\item{k}{numeric, the \emph{penalty} per parameter to be used; the
    default \code{k = 2} is the classical AIC.}
}
\description{
Computes the Akaike's information criterion or the Schwarz's Bayesian criterion
for hyper-Poisson Fits
}
\examples{
## Fit a hyper-Poisson model
Bids$size.sq <- Bids$size ^ 2
fit <- glm.hP(formula.mu = numbids ~ leglrest + rearest + finrest +
              whtknght + bidprem + insthold + size + size.sq + regulatn,
              formula.gamma = numbids ~ 1, data = Bids)

## Obtain its AIC and BIC
AIC(fit)
BIC(fit)
}
