% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiffHotspots_n_k.R
\name{DiffHotspots_n_k}
\alias{DiffHotspots_n_k}
\title{Identifies differential risk hotspots along a linear network given a vector of relative probabilities computed over the middle points of the segments of the network}
\usage{
DiffHotspots_n_k(X, W, relative_probabilities, k, n)
}
\arguments{
\item{X}{- A \code{lpp} object representing a marked point pattern lying on a road network (\code{linnet} object)}

\item{W}{- A \code{listw} object representing the neighbourhood structure that the road segments of the network form, possibly generated through the function \code{NeighbourhoodMatrixNetwork}}

\item{relative_probabilities}{- An object containing the relative probabilities of a specific type of event along the linear network contained in \code{X}, generated through the function \code{RelativityProbabilityNetwork}}

\item{k}{- A numeric value that controls the procedure of detecting differential risk hotspots (departure from average relative probability), as described above}

\item{n}{- A numeric value that controls the procedure of detecting differential risk hotspots (minimum size for the sample of events implicated in the computation of the relative probabilities), as described above}
}
\value{
Returns a list that contains the differential risk hotspots found for \code{X}, given the value of \code{relative_probabilities}
}
\description{
Given the relative probabilities of an event's occurrence along the middle points of a linear network, this function filters and groups in hotspots those segments satisfying two conditions: 1) exceeding the average of the relative probabilities for all the events in the network in \code{k} times the standard deviation of the set of probabilities, and 2) having provided \code{n} or more events of the network for the computation of their corresponding relative probability (a factor that depends on the choice of \code{sigma} when using the function \code{RelativeProbabilityNetwork}). In summary, \code{k} and \code{n} control the formation of differential risk hotspots along the network, given a set of relative probabilities covering the network. The choice of a higher value for \code{k} or \code{n} (or both) is more demanding and leads to a lower number of differential risk hotspots being detected. Users should test several values of \code{k} and \code{n} (sensitivity analysis on \code{k} and \code{n}) in order to reach reasonable choices for the research or practical purposes of their data analysis
}
\examples{
library(DRHotNet)
library(spatstat)
library(spdep)
library(raster)
library(maptools)
\donttest{
network=SampleMarkedPattern$domain
X=SampleMarkedPattern
network_lix=lixellate(network,eps=50)
X_lix=lpp(cbind(X$data$x,X$data$y),network_lix)
marks(X_lix)=marks(X)
sigma=100
collision_type="Rear-end"
W=NeighbourhoodMatrixNetwork(network_lix)
projection="+proj=utm +zone=30 ellps=WGS84 +ellps=WGS84"
network_lix_sp=as.SpatialLines.psp(as.psp(network_lix))
proj4string(network_lix_sp)=projection
middle_points=SpatialLinesMidPoints(network_lix_sp)@coords
x=middle_points[,1]
y=middle_points[,2]
relative_probabilities=RelativeProbabilityNetwork(X_lix,W,sigma,x,y, 
                       "Collision",collision_type)
k=1
n=20
hotspots=DiffHotspots_n_k(X_lix,W,relative_probabilities,k,n)
}
}
