% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drsens.R
\name{drsens}
\alias{drsens}
\title{Performs a sensitivity analysis on the parameters \code{k} and \code{n} that are provided to \code{drhot}}
\usage{
drsens(X, rel_probs, ks, ns)
}
\arguments{
\item{X}{- A \code{lpp} object representing a marked point pattern lying on a road network (\code{linnet} object)}

\item{rel_probs}{- An object containing the relative probabilities of a specific type of event along the linear network contained in \code{X}, generated through the function \code{relpnet}}

\item{ks}{- A numeric vector of possible values for the \code{k} parameter that is provided to \code{drhot}}

\item{ns}{- A numeric vector of possible values for the \code{n} parameter that is provided to \code{drhot}}
}
\value{
A matrix providing the type-specific prediction accuracy index that corresponds to the set differential risk hotspots obtained for each value of \code{k} or \code{n} provided in \code{ks} and \code{ns}, respectively. A \code{NA} value in this matrix indicates that no differential risk hotspots are found for the corresponding combination of \code{k} and \code{n}
}
\description{
Given a set of \code{ks} and \code{ns} parameters, this function allows the user to perform a sensitivity analysis on the parameters \code{k} and \code{n} by calling \code{drhot} for each combination of \code{k} and \code{n}
}
\examples{
library(DRHotNet)
library(spatstat.geom)
library(spatstat.linnet)
library(spdep)
library(raster)
\donttest{
rel_probs_rear_end <- relpnet(X = SampleMarkedPattern,
lixel_length = 50,h = 100,mark = "Collision",category_mark = "Rear-end")
sensitivity_analysis <- drsens(X = SampleMarkedPattern, rel_probs = rel_probs_rear_end, 
ks = c(1,2), ns = c(30,40))
}
}
\references{
Briz-Redon, A., Martinez-Ruiz, F., & Montes, F. (2019). Identification of differential risk hotspots for collision and vehicle type in a directed linear network. Accident Analysis & Prevention, 132, 105278.
}
