#' SIRSd model
#'
#' @description A SIRSd model with 3 compartments. Processes are infection, recovery, births deaths and waning immunity.
#'
#' @details The model includes susceptible, infected, and recovered compartments. The processes which are modeled are infection, recovery, natural births and deaths and waning immunity.
#'
#' This code was generated by the modelbuilder R package.
#' The model is implemented as a set of ordinary differential equations using the deSolve package.
#' The following R packages need to be loaded for the function to work: deSolve.
#'
#' Starting conditions for model variables
#' @param S : starting value for Susceptible : numeric
#' @param I : starting value for Infected : numeric
#' @param R : starting value for Recovered : numeric
#' Values for model parameters : numeric
#' @param b : infection rate : numeric
#' @param g : recovery rate : numeric
#' @param n : birth rate : numeric
#' @param m : death rate : numeric
#' @param w : waning immunity rate : numeric
#' Values for model times : numeric
#' @param tstart : Start time of simulation : numeric
#' @param tfinal : Final time of simulation : numeric
#' @param dt : Time step : numeric
#' @return The function returns the output as a list.
#' The time-series from the simulation is returned as a dataframe saved as list element \code{ts}.
#' The \code{ts} dataframe has one column per compartment/variable. The first column is time.
#' @examples
#' # To run the simulation with default parameters:
#' result <- simulate_SIRSd_model_ode()
#' # To choose values other than the standard one, specify them like this:
#' result <- simulate_SIRSd_model_ode(S = 2000,I = 2,R = 0)
#' # You can display or further process the result, like this:
#' plot(result$ts[,'time'],result$ts[,'S'],xlab='Time',ylab='Numbers',type='l')
#' print(paste('Max number of S: ',max(result$ts[,'S'])))
#' @section Warning: This function does not perform any error checking. So if you try to do something nonsensical (e.g. have negative values for parameters), the code will likely abort with an error message.
#' @section Model Author: Andreas Handel
#' @section Model creation date: 2020-09-01
#' @section Code Author: generated by the \code{modelbuilder} R package
#' @section Code creation date: 2020-09-28
#' @export

simulate_SIRSd_model_ode <- function(S = 1000, I = 1, R = 0, b = 0.002, g = 1, n = 0, m = 0, w = 1, tstart = 0, tfinal = 100, dt = 0.1)
{
  ##############################
  #Block of ODE equations for deSolve
  ##############################
  SIRSd_model_ode_fct <- function(t, y, parms)
  {
    with( as.list(c(y,parms)), { #lets us access variables and parameters stored in y and parms by name
    #StartODES
    #Susceptible : infection : waning immunity : births : natural deaths :
    dS_mb = -b*S*I +w*R +n -m*S
    #Infected : infection : recovery : natural deaths :
    dI_mb = +b*S*I -g*I -m*I
    #Recovered : recovery : waning immunity : natural death :
    dR_mb = +g*I -w*R -m*R
    #EndODES
    list(c(dS_mb,dI_mb,dR_mb))
  } ) } #close with statement, end ODE code block

  ##############################
  #Main function code block
  ##############################
  #Creating named vectors
  varvec_mb = c(S = S, I = I, R = R)
  parvec_mb = c(b = b, g = g, n = n, m = m, w = w)
  timevec_mb = seq(tstart, tfinal,by = dt)
  #Running the model
  simout = deSolve::ode(y = varvec_mb, parms = parvec_mb, times = timevec_mb,  func = SIRSd_model_ode_fct, rtol = 1e-12, atol = 1e-12)
  #Setting up empty list and returning result as data frame called ts
  result <- list()
  result$ts <- as.data.frame(simout)
  return(result)
}
