#' Host Heterogeneity Model
#' 
#' @description An SIR type model stratified for two different types of hosts.
#' 
#' @details This model tracks susceptibles, infected and recovered of 2 different types. Think of those types as e.g. males/females, children/adults, etc. The model includes infection, recovery and waning immunity processes for both hosts.
#' 
#' This code was generated by the modelbuilder R package.  
#' The model is implemented as a set of ordinary differential equations using the deSolve package. 
#' The following R packages need to be loaded for the function to work: deSolve. 
#' 
#' Starting conditions for model variables 
#' @param S1 : starting value for Susceptible type 1 hosts : numeric
#' @param I1 : starting value for Infected type 1 hosts : numeric
#' @param R1 : starting value for Recovered type 1 hosts : numeric
#' @param S2 : starting value for Susceptible type 2 hosts : numeric
#' @param I2 : starting value for Infected type 2 hosts : numeric
#' @param R2 : starting value for Recovered type 2 hosts : numeric
#' Values for model parameters : numeric 
#' @param b11 : rate of transmission to susceptible type 1 host from infected type 1 host : numeric
#' @param b12 : rate of transmission to susceptible type 1 host from infected type 2 host : numeric
#' @param b21 : rate of transmission to susceptible type 2 host from infected type 1 host : numeric
#' @param b22 : rate of transmission to susceptible type 2 host from infected type 2 host : numeric
#' @param g1 : the rate at which infected type 1 hosts recover : numeric
#' @param g2 : the rate at which infected type 2 hosts recover : numeric
#' @param w1 : the rate at which type 1 host immunity wanes : numeric
#' @param w2 : the rate at which type 2 host immunity wanes : numeric
#' Values for model times : numeric 
#' @param tstart : Start time of simulation : numeric
#' @param tfinal : Final time of simulation : numeric
#' @param dt : Time step : numeric
#' @return The function returns the output as a list. 
#' The time-series from the simulation is returned as a dataframe saved as list element \code{ts}. 
#' The \code{ts} dataframe has one column per compartment/variable. The first column is time.   
#' @examples  
#' # To run the simulation with default parameters:  
#' result <- simulate_Host_Heterogeneity_Model_ode() 
#' # To choose values other than the standard one, specify them like this:  
#' result <- simulate_Host_Heterogeneity_Model_ode(S1 = 2000,I1 = 2,R1 = 0,S2 = 400,I2 = 2,R2 = 0) 
#' # You can display or further process the result, like this:  
#' plot(result$ts[,'time'],result$ts[,'S1'],xlab='Time',ylab='Numbers',type='l') 
#' print(paste('Max number of S1: ',max(result$ts[,'S1']))) 
#' @section Warning: This function does not perform any error checking. So if you try to do something nonsensical (e.g. have negative values for parameters), the code will likely abort with an error message.
#' @section Model Author: Andreas Handel, Alexis Vittengl
#' @section Model creation date: 2020-09-24
#' @section Code Author: generated by the \code{modelbuilder} R package 
#' @section Code creation date: 2020-09-24
#' @export 
 
simulate_Host_Heterogeneity_Model_ode <- function(S1 = 1000, I1 = 1, R1 = 0, S2 = 200, I2 = 1, R2 = 0, b11 = 0.01, b12 = 0, b21 = 0, b22 = 0, g1 = 1, g2 = 1, w1 = 0, w2 = 0, tstart = 0, tfinal = 60, dt = 0.1) 
{ 
  ############################## 
  #Block of ODE equations for deSolve 
  ############################## 
  Host_Heterogeneity_Model_ode_fct <- function(t, y, parms) 
  {
    with( as.list(c(y,parms)), { #lets us access variables and parameters stored in y and parms by name 
    #StartODES
    #Susceptible type 1 hosts : Susceptible 1 hosts infected by infected 1 hosts : Susceptible 1 hosts infected by infected 2 hosts : Loss of immunity by recovered 1 hosts :
    dS1_mb = -b11*S1*I1 -b12*S1*I2 +w1*R1
    #Infected type 1 hosts : Susceptible 1 hosts infected by infected 1 hosts : Susceptible 1 hosts infected by infected 2 hosts : Infected 1 hosts recovery :
    dI1_mb = +b11*S1*I1 +b12*S1*I2 -g1*I1
    #Recovered type 1 hosts : Infected 1 hosts recovery : Loss of immunity by recovered 1 hosts :
    dR1_mb = +g1*I1 -w1*R1
    #Susceptible type 2 hosts : Susceptible 2 hosts infected by infected 1 hosts : Susceptible 2 hosts infected by infected 2 hosts : Loss of immunity by recovered 2 hosts :
    dS2_mb = -b21*S2*I1 -b22*S2*I2 +w2*R2
    #Infected type 2 hosts : Susceptible 2 hosts infected by infected 1 hosts : Susceptible 2 hosts infected by infected 2 hosts : Infected 2 hosts recovery :
    dI2_mb = +b21*S2*I1 +b22*S2*I2 -g2*I2
    #Recovered type 2 hosts : Infected 2 hosts recovery : Loss of immunity by recovered 2 hosts :
    dR2_mb = +g2*I2 -w2*R2
    #EndODES
    list(c(dS1_mb,dI1_mb,dR1_mb,dS2_mb,dI2_mb,dR2_mb)) 
  } ) } #close with statement, end ODE code block 
 
  ############################## 
  #Main function code block 
  ############################## 
  #Creating named vectors 
  varvec_mb = c(S1 = S1, I1 = I1, R1 = R1, S2 = S2, I2 = I2, R2 = R2) 
  parvec_mb = c(b11 = b11, b12 = b12, b21 = b21, b22 = b22, g1 = g1, g2 = g2, w1 = w1, w2 = w2) 
  timevec_mb = seq(tstart, tfinal,by = dt) 
  #Running the model 
  simout = deSolve::ode(y = varvec_mb, parms = parvec_mb, times = timevec_mb,  func = Host_Heterogeneity_Model_ode_fct, rtol = 1e-12, atol = 1e-12) 
  #Setting up empty list and returning result as data frame called ts 
  result <- list() 
  result$ts <- as.data.frame(simout) 
  return(result) 
} 
