% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OpalConnection.R
\name{dsConnect,OpalDriver-method}
\alias{dsConnect,OpalDriver-method}
\title{Connect to a Opal server}
\usage{
\S4method{dsConnect}{OpalDriver}(
  drv,
  name,
  restore = NULL,
  username = NULL,
  password = NULL,
  token = NULL,
  url = NULL,
  opts = list(),
  ...
)
}
\arguments{
\item{drv}{\code{\link{OpalDriver-class}} class object.}

\item{name}{Name of the connection, which must be unique among all the DataSHIELD connections.}

\item{restore}{Workspace name to be restored in the newly created DataSHIELD R session.}

\item{username}{User name in opal(s).}

\item{password}{User password in opal(s).}

\item{token}{Personal access token (since opal 2.15, ignored if username is specified).}

\item{url}{Opal url or list of opal urls. Can be provided by "opal.url" option.}

\item{opts}{Curl options as described by httr (call httr::httr_options() for details). Can be provided by "opal.opts" option.}

\item{...}{Unused, needed for compatibility with generic.}
}
\value{
A \code{\link{OpalConnection-class}} object.
}
\description{
Connect to a Opal server, with provided credentials. Does not create a DataSHIELD R session, only retrieves user profile.
}
\examples{
\dontrun{
con <- dsConnect(DSOpal::Opal(), "server1", "username", "password", "https://opal.example.org")
con
dsDisconnect(con)
}

}
