% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BooleanTable.R
\name{autoplot.BooleanTable}
\alias{autoplot.BooleanTable}
\alias{autolayer.BooleanTable}
\title{Plot of Predictive Values of Boolean Test-&-Disease Table}
\usage{
\method{autolayer}{BooleanTable}(object, prevalence, ...)

\method{autoplot}{BooleanTable}(object, ...)
}
\arguments{
\item{object}{a \linkS4class{BooleanTable} object}

\item{prevalence}{(optional) \link[base]{numeric} scalar, prevalence of disease}

\item{...}{potential parameters, currently not in use}
}
\value{
Function \link{autoplot.BooleanTable} returns a \link[ggplot2]{ggplot} figure,
which shows the curves of positive and negative predictive values for prevalence from 0 to 1.
}
\description{
Plot of predictive values of Boolean test-&-disease table
}
\examples{
(x = array(c(95L, 10L, 31L, 82L), dim = c(2L, 2L)))
autoplot(BooleanTable(x))
autoplot(BooleanTable(x), prevalence = .13)

}
\seealso{
\link{summary.BooleanTable}
}
