% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BooleanTable.R
\name{summary.BooleanTable}
\alias{summary.BooleanTable}
\title{Summarize Boolean Test-&-Disease and/or Risk-&-Disease Table}
\usage{
\method{summary}{BooleanTable}(object, prevalence, ...)
}
\arguments{
\item{object}{a \linkS4class{BooleanTable} object}

\item{prevalence}{(optional) \link[base]{numeric} scalar, prevalence of disease}

\item{...}{potential parameters, currently not in use}
}
\value{
[summary.BooleanTable] do not have a returned value.
}
\description{
Summarize Boolean test-&-disease and/or risk-&-disease table using 
sensitivity, specificity, diagnostic accuracy, predictive values, relative risk 
and odds ratio, 
together with their \eqn{95\%} Clopper-Pearson exact confidence intervals.
}
\details{
..
}
\examples{
(x = array(c(95L, 10L, 31L, 82L), dim = c(2L, 2L)))
summary(BooleanTable(x))
summary(BooleanTable(x), prevalence = .14)

}
\references{
\url{https://en.wikipedia.org/wiki/Diagnostic_odds_ratio}
}
