% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yamlR.R
\name{yml_find}
\alias{yml_find}
\alias{yml_add_files}
\alias{yml_disable_compile}
\alias{yml_enable_compile}
\alias{yml_add_objects}
\alias{yml_list_objects}
\alias{yml_list_files}
\alias{yml_remove_objects}
\alias{yml_remove_files}
\alias{yml_write}
\title{Edit DataPackageR yaml configuration}
\usage{
yml_find(path)

yml_add_files(config, filenames)

yml_disable_compile(config, filenames)

yml_enable_compile(config, filenames)

yml_add_objects(config, objects)

yml_list_objects(config)

yml_list_files(config)

yml_remove_objects(config, objects)

yml_remove_files(config, filenames)

yml_write(config, path = NULL)
}
\arguments{
\item{path}{Path to the data package source or path to write config file (for \code{yml_write})}

\item{config}{an R representation of the datapackager.yml config, returned by yml_find, or a path to the package root.}

\item{filenames}{A vector of filenames.}

\item{objects}{A vector of R object names.}
}
\value{
A yaml configuration structured as an R nested list.
}
\description{
Edit a yaml configuration file via an API.
}
\details{
Add, remove files and objects, enable or disable parsing of specific files,  list objects or files in a yaml config, or write a config back to a package.
}
\examples{
if(rmarkdown::pandoc_available()){
f <- tempdir()
f <- file.path(f,"foo.Rmd")
con <- file(f)
writeLines("```{r}\\n tbl = table(sample(1:10,1000,replace=TRUE)) \\n```\\n",con=con)
close(con)
pname <- basename(tempfile())
datapackage_skeleton(name=pname,
   path = tempdir(),
   force = TRUE,
   r_object_names = "tbl",
   code_files = f)
yml <- yml_find(file.path(tempdir(),pname))
cat(yaml::as.yaml(yml))
yml <- yml_add_files(yml,"foo.Rmd")
yml_list_files(yml)
yml <- yml_disable_compile(yml,"foo.Rmd")
cat(yaml::as.yaml(yml))
yml <- yml_enable_compile(yml,"foo.Rmd")
cat(yaml::as.yaml(yml))
yml <- yml_add_objects(yml,"data1")
yml_list_objects(yml)
yml <- yml_remove_objects(yml,"data1")
yml <- yml_remove_files(yml,"foo.Rmd")
}
}
