/*
 * Decompiled with CFR 0.152.
 */
package net.starschema.clouddb.jdbc.list;

import java.util.ArrayList;
import java.util.List;
import net.starschema.clouddb.jdbc.JdbcGrammarParser;
import net.starschema.clouddb.jdbc.antlr.sqlparse.ColumnCallException;
import net.starschema.clouddb.jdbc.antlr.sqlparse.TreeParsingException;
import net.starschema.clouddb.jdbc.list.ColumnCall;
import net.starschema.clouddb.jdbc.list.Expression;
import net.starschema.clouddb.jdbc.list.FunctionCall;
import net.starschema.clouddb.jdbc.list.Node;
import net.starschema.clouddb.jdbc.list.SelectStatement;
import net.starschema.clouddb.jdbc.list.SynonymContainer;
import net.starschema.clouddb.jdbc.list.TreeBuilder;
import org.antlr.runtime.tree.Tree;

public class SubQuery
extends Node {
    String alias = null;
    SelectStatement selectStatement = null;
    TreeBuilder builder;
    private boolean isPartOfJoin = false;
    private String uniqueId;

    public void setisPartOfJoin() {
        this.isPartOfJoin = true;
    }

    public boolean isPartOfJoin() {
        return this.isPartOfJoin;
    }

    public SubQuery(String alias, TreeBuilder builder, SelectStatement selectStatement) {
        this.builder = builder;
        this.selectStatement = selectStatement;
        selectStatement.setParent(this);
        this.alias = alias;
        this.tokenType = 126;
        this.tokenName = JdbcGrammarParser.tokenNames[126];
        this.uniqueId = builder.getuniqueid();
    }

    public SubQuery(String alias, TreeBuilder builder, SelectStatement selectStatement, String uniqueId) {
        this.builder = builder;
        this.selectStatement = selectStatement;
        selectStatement.setParent(this);
        this.alias = alias;
        this.tokenType = 126;
        this.tokenName = JdbcGrammarParser.tokenNames[126];
        this.uniqueId = uniqueId;
    }

    public SubQuery(Tree t, TreeBuilder treeBuilder) throws TreeParsingException {
        this.builder = treeBuilder;
        this.uniqueId = this.builder.getuniqueid();
        this.build(t, this.builder);
    }

    public void build(Tree t, TreeBuilder builder) throws TreeParsingException {
        if (t.getType() == 126) {
            this.tokenName = JdbcGrammarParser.tokenNames[t.getType()];
            this.logger.debug("BUILDING " + this.tokenName);
            this.tokenType = t.getType();
            block6: for (int i = 0; i < t.getChildCount(); ++i) {
                Tree child = t.getChild(i);
                switch (child.getType()) {
                    case 121: {
                        try {
                            this.selectStatement = new SelectStatement(child, builder);
                        }
                        catch (ColumnCallException e) {
                            throw new TreeParsingException(e);
                        }
                        this.selectStatement.parent = this;
                        continue block6;
                    }
                    case 5: {
                        this.alias = child.getChild(0).getText();
                    }
                }
            }
            if (this.getAlias() == null) {
                this.alias = this.uniqueId;
            }
        } else {
            throw new TreeParsingException("This Tree is not a SUBQUERY");
        }
    }

    public String getAlias() {
        return this.alias;
    }

    public List<SynonymContainer> getAvailableResources() {
        List<String> synonyms;
        SynonymContainer columnCallSynonymContainer;
        Expression expression = this.selectStatement.getExpression();
        List<ColumnCall> columns = expression.getColumns();
        List<FunctionCall> functionCalls = expression.getFunctionCalls();
        ArrayList<SynonymContainer> container = new ArrayList<SynonymContainer>();
        if (columns != null) {
            for (ColumnCall columnCall : columns) {
                columnCallSynonymContainer = new SynonymContainer(columnCall);
                synonyms = columnCall.getSynonyms();
                if (synonyms != null) {
                    for (String string : synonyms) {
                        columnCallSynonymContainer.addSynonym(string);
                    }
                }
                container.add(columnCallSynonymContainer);
            }
        }
        if (functionCalls != null) {
            for (FunctionCall functionCall : functionCalls) {
                columnCallSynonymContainer = new SynonymContainer(functionCall);
                synonyms = functionCall.getSynonyms();
                if (synonyms != null) {
                    for (String string : synonyms) {
                        columnCallSynonymContainer.addSynonym(string);
                    }
                }
                container.add(columnCallSynonymContainer);
            }
        }
        return container;
    }

    public SelectStatement getSelectStatement() {
        return this.selectStatement;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public String toPrettyString() {
        return this.toPrettyString(-1);
    }

    @Override
    public String toPrettyString(int level) {
        int newlevel = level < 0 ? -1 : level;
        String result = this.alias != null ? this.tab(level - 1) + "(" + this.selectStatement.toPrettyString(newlevel) + ") " + this.alias + newline : this.tab(level - 1) + "(" + this.selectStatement.toPrettyString(newlevel) + ")" + newline;
        return result;
    }
}

