/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase.toolkit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.Constructor;
import org.rosuda.ibase.SVarSet;
import org.rosuda.ibase.toolkit.AWTGraphicsDevice;
import org.rosuda.ibase.toolkit.AwtQueryPopup;
import org.rosuda.ibase.toolkit.GraphicsDevice;
import org.rosuda.ibase.toolkit.PlotJPanel;
import org.rosuda.ibase.toolkit.QueryPopup;
import org.rosuda.ibase.toolkit.SWINGGraphicsDevice;
import org.rosuda.ibase.toolkit.SwingQueryPopup;
import org.rosuda.pograss.PoGraSS;

public abstract class PlotComponent {
    public static final int AWTGrDevID = 0;
    public static final int SWINGGrDevID = 1;
    public static final int JOGLGrDevID = 2;
    public final int GrDevID;
    private GraphicsDevice grdev;
    public int layers;

    public PlotComponent(int n, int n2) {
        this.GrDevID = n;
        this.layers = n2;
        this.grdev = null;
        if (n == 0) {
            this.grdev = new AWTGraphicsDevice(this.layers);
        } else if (n == 1) {
            this.grdev = new SWINGGraphicsDevice(this.layers);
        } else if (n == 2) {
            try {
                Constructor<?> constructor;
                Class<?> clazz = Class.forName("org.rosuda.ibase.toolkit.JOGLGraphicsDevice");
                if (clazz != null && (constructor = clazz.getConstructor(Integer.TYPE, Boolean.TYPE)) != null) {
                    this.grdev = (GraphicsDevice)constructor.newInstance(new Integer(n2), new Boolean(true));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.grdev == null) {
            this.grdev = new AWTGraphicsDevice(this.layers);
        }
        this.grdev.setPCOwner(this);
    }

    public PlotComponent(int n) {
        this(n, 1);
    }

    public void paintLayer(int n) {
        this.grdev.paintLayer(n);
    }

    public abstract void paintPoGraSS(PoGraSS var1);

    protected abstract void beginPaint(PoGraSS var1);

    protected abstract void endPaint(PoGraSS var1);

    public void repaint() {
        this.grdev.repaint();
    }

    public void setUpdateRoot(int n) {
        this.grdev.setUpdateRoot(n);
    }

    public QueryPopup newQueryPopup(Window window, SVarSet sVarSet, String string, int n, int n2) {
        if (this.GrDevID == 1) {
            return new SwingQueryPopup((SWINGGraphicsDevice)this.grdev, window, sVarSet, string, n, n2);
        }
        if (this.GrDevID == 2) {
            return new AwtQueryPopup(window, sVarSet, string, n, n2);
        }
        return new AwtQueryPopup(window, sVarSet, string, n, n2);
    }

    public QueryPopup newQueryPopup(Window window, SVarSet sVarSet, String string) {
        return this.newQueryPopup(window, sVarSet, string, -1, -1);
    }

    public void setToolTipText(String string) {
        if (this.GrDevID == 1) {
            ((PlotJPanel)this.grdev.getComponent()).setToolTipText(string);
        }
    }

    public Component getComponent() {
        return this.grdev.getComponent();
    }

    public Rectangle getBounds() {
        return this.grdev.getBounds();
    }

    public void setSize(int n, int n2) {
        this.grdev.setSize(n, n2);
    }

    public Dimension getSize() {
        return this.grdev.getSize();
    }

    public void setBackground(Color color) {
        this.grdev.setBackground(color);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.grdev.addMouseListener(mouseListener);
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.grdev.addMouseMotionListener(mouseMotionListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.grdev.addKeyListener(keyListener);
    }

    public Point getLocation() {
        return this.grdev.getLocation();
    }

    public void setCursor(Cursor cursor) {
        this.grdev.setCursor(cursor);
    }

    public void setSize(Dimension dimension) {
        this.grdev.setSize(dimension);
    }

    public int getWidth() {
        return this.grdev.getWidth();
    }

    public int getHeight() {
        return this.grdev.getHeight();
    }

    public Container getParent() {
        return this.grdev.getParent();
    }
}

