% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/add_to_series.R
\name{add_to_series}
\alias{add_to_series}
\title{Add graph object to a graph series object}
\usage{
add_to_series(graph, graph_series)
}
\arguments{
\item{graph}{a graph object to add to the graph series object.}

\item{graph_series}{a graph series object to which the graph object will be
added.}
}
\value{
a graph series object of type \code{dgr_graph_1D}.
}
\description{
Add a graph object to an extant graph series object for
storage of multiple graphs across a sequential or temporal one-dimensional
array.
}
\examples{
\dontrun{
# Create three graphs (using \\code{pipeR} for speed)
# and create a graph series using those graphs
library(magrittr)

graph_1 <- create_graph() \%>\%
  add_node("a") \%>\% add_node("b") \%>\% add_node("c") \%>\%
  add_edges(from = c("a", "a", "b"),
            to =   c("c", "b", "c"))

graph_2 <- graph_1 \%>\%
  add_node("d") \%>\% add_edges(from = "d", to = "c")

graph_3 <- graph_2 \%>\%
  add_node("e") \%>\% add_edges(from = "e", to = "b")

# Create an empty graph series
series <- create_series(series_type = "sequential")

# Add graphs to the graph series
series <- graph_1 \%>\% add_to_series(series)
series <- graph_2 \%>\% add_to_series(series)
series <- graph_3 \%>\% add_to_series(series)
}
}

