% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/select_graph_from_series.R
\name{select_graph_from_series}
\alias{select_graph_from_series}
\title{Select a graph available in a series}
\usage{
select_graph_from_series(graph_series, graph_no)
}
\arguments{
\item{graph_series}{a graph series object of type \code{dgr_graph_1D}.}

\item{graph_no}{the index of the graph in the graph series.}
}
\description{
Using a graph series object of type \code{dgr_graph_1D}, select
a graph object.
}
\examples{
\dontrun{
# Create three graphs (using \\code{magrittr} for piping)
# and create a graph series using those graphs
library(magrittr)

graph_1 <- create_graph() \%>\%
  add_node("a") \%>\% add_node("b") \%>\% add_node("c") \%>\%
  add_edges(from = c("a", "a", "b"),
            to =   c("c", "b", "c"))

graph_2 <- graph_1 \%>\%
  add_node("d") \%>\% add_edges(from = "d", to = "c")

graph_3 <- graph_2 \%>\%
  add_node("e") \%>\% add_edges(from = "e", to = "b")

# Create an empty graph series
series <- create_series(series_type = "sequential")

# Add graphs to the graph series
series <- graph_1 \%>\% add_to_series(series)
series <- graph_2 \%>\% add_to_series(series)
series <- graph_3 \%>\% add_to_series(series)

# Select the second graph in the series
extracted_graph <-
  select_graph_from_series(graph_series = series,
                           graph_no = 2)
}
}

