% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_non_nbrs.R
\name{get_non_nbrs}
\alias{get_non_nbrs}
\title{Get non-neighbors of a node in a graph}
\usage{
get_non_nbrs(graph, node)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph} that is created using
\code{create_graph}.}

\item{node}{a single-length vector containing a
node ID value.}
}
\value{
a vector of node ID values.
}
\description{
Get the set of all nodes not
neighboring a single graph node.
}
\examples{
library(magrittr)

# Create a random, directed graph with 18 nodes
# and 22 edges
random_graph <-
  create_random_graph(
    n = 18,
    m = 22,
    directed = TRUE,
    fully_connected = TRUE,
    set_seed = 20) \%>\%
  set_global_graph_attrs(
    'graph', 'layout', 'sfdp') \%>\%
  set_global_graph_attrs(
    'graph', 'overlap', 'false')

# Find all non-neighbors of node `5`
random_graph \%>\%
  get_non_nbrs(5)
#>  [1] "3"  "4"  "6"  "7"  "8"  "9"  "10" "11" "13"
#> [12] "14" "15" "16" "17"
}

