% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_info.R
\name{node_info}
\alias{node_info}
\title{Get detailed information on nodes}
\usage{
node_info(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a data frame containing information specific
to each node within the graph.
}
\description{
Obtain a data frame with detailed
information on nodes and their interrelationships
within a graph.
}
\examples{
# Create a node data frame (ndf)
nodes <-
  create_nodes(
    nodes = LETTERS,
    label = TRUE,
    type = c(rep("a_to_g", 7),
             rep("h_to_p", 9),
             rep("q_to_x", 8),
             rep("y_and_z",2)))

# Create an edge data frame (edf)
edges <-
  create_edges(
    from = sample(LETTERS, replace = TRUE),
    to = sample(LETTERS, replace = TRUE),
    rel = "letter_to_letter")

# Create a graph
graph <-
  create_graph(nodes_df = nodes,
               edges_df = edges)

# Get information on the graph's nodes
node_info(graph)
#>    node label    type deg indeg outdeg loops
#> 1     A     A  a_to_g   1     0      1     0
#> 2     B     B  a_to_g   1     0      1     0
#> 3     C     C  a_to_g   3     2      1     0
#> 4     D     D  a_to_g   1     1      0     0
#> 5     E     E  a_to_g   1     0      1     0
#> 6     F     F  a_to_g   2     1      1     0
#>..   ...   ...     ... ...   ...    ...   ...
}

