% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_similar_nbrs.R
\name{get_similar_nbrs}
\alias{get_similar_nbrs}
\title{Get neighboring nodes based on node attribute
similarity}
\usage{
get_similar_nbrs(graph, node, node_attr, tol_abs = NULL, tol_pct = NULL)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{node}{a single-length vector containing a
node ID value.}

\item{node_attr}{the name of the node attribute
to use to compare with adjacent nodes.}

\item{tol_abs}{if the values contained in the node
attribute \code{node_attr} are numeric, one can
optionally supply a numeric vector of length 2 that
provides a lower and upper numeric bound as criteria
for neighboring node similarity to the starting
node.}

\item{tol_pct}{if the values contained in the node
attribute \code{node_attr} are numeric, one can
optionally supply a numeric vector of length 2 that
specifies lower and upper bounds as negative and
positive percentage changes to the value of the
starting node. These bounds serve as criteria for
neighboring node similarity to the starting node.}
}
\value{
a vector of node ID values.
}
\description{
With a graph a single node serving as
the starting point, get those nodes in a potential
neighborhood of nodes (adjacent to the starting
node) that have a common or similar (within
threshold values) node attribute to the starting
node.
}
\examples{
# Getting similar neighbors can be done through
# numerical comparisons; start with creating a
# random, directed graph with 18 nodes and 22 edges
graph <-
  create_random_graph(
    n = 18, m = 22,
    set_seed = 23)

# The `create_random_graph()` function randomly
# assigns numerical values to all nodes (as the
# `value` attribute) from 0 to 10 and to 1 decimal
# place. By starting with node (`8`), we can test
# whether any nodes adjacent and beyond are
# numerically equivalent in `value`
graph \%>\%
  get_similar_nbrs(
    node = 8,
    node_attr = "value")
#> [1] 7 10

# We can also set a tolerance for ascribing
# similarly by using either the `tol_abs` or
# `tol_pct` arguments (the first applies absolute
# lower and upper bounds from the value in the
# starting node and the latter uses a percentage
# difference to do the same); try setting `tol_abs`
# with a fairly large range to determine if several
# nodes can be selected
graph \%>\%
  get_similar_nbrs(
    node = 8,
    node_attr = "value",
    tol_abs = c(3, 3))
#> [1]  7  9 10 11 12

# That resulted in a fairly large set of 5
# neigboring nodes; For sake of example, setting the
# range to be very large will effectively return all
# nodes in the graph except for the starting node
graph \%>\%
  get_similar_nbrs(
    node = 8,
    node_attr = "value",
    tol_abs = c(10, 10)) \%>\%
    length()
#> [1] 13
}

