% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nudge_node_positions_ws.R
\name{nudge_node_positions_ws}
\alias{nudge_node_positions_ws}
\title{Move layout positions of a selection of nodes}
\usage{
nudge_node_positions_ws(graph, dx, dy)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{dx}{a single numeric value specifying the
amount that selected nodes (with non-\code{NA}
values for the \code{x} and \code{y} attributes)
will be moved in the x direction. A positive
value will move nodes right, negative left.}

\item{dy}{a single numeric value specifying the
amount that selected nodes (with non-\code{NA}
values for the \code{x} and \code{y} attributes)
will be moved in the y direction. A positive
value will move nodes up, negative down.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
With an active selection of nodes,
move the position in either the \code{x} or
\code{y} directions, or both. Nodes in the
selection that do not have position information
(i.e., \code{NA} values for the \code{x} or
\code{y} node attributes) will be ignored.
}
\examples{
# Create a simple graph with 4 nodes
graph <-
  create_graph() \%>\%
  add_node(type = "a", label = "one") \%>\%
  add_node(type = "a", label = "two") \%>\%
  add_node(type = "b", label = "three") \%>\%
  add_node(type = "b", label = "four")

# Add position information to each of
# the graph's nodes
graph <-
  graph \%>\%
  set_node_position(
    node = 1, x = 1, y = 1) \%>\%
  set_node_position(
    node = 2, x = 2, y = 2) \%>\%
  set_node_position(
    node = 3, x = 3, y = 3) \%>\%
  set_node_position(
    node = 4, x = 4, y = 4)

# Select all of the graph's nodes using the
# `select_nodes()` function (and only
# specifying the graph object)
graph <- select_nodes(graph)

# Move the selected nodes (all the nodes,
# in this case) 5 units to the right
graph <-
  graph \%>\%
  nudge_node_positions_ws(
    dx = 5, dy = 0)

# View the graph's node data frame
get_node_df(graph)
#>   id type label x y
#> 1  1    a   one 6 1
#> 2  2    a   two 7 2
#> 3  3    b three 8 3
#> 4  4    b  four 9 4

# Now select nodes that have `type == "b"`
# and move them in the `y` direction 2 units
# (the graph still has an active selection
# and so it must be cleared first)
graph <-
  graph \%>\%
  clear_selection() \%>\%
  select_nodes("type == 'b'") \%>\%
  nudge_node_positions_ws(
    dx = 0, dy = 2)

# View the graph's node data frame
get_node_df(graph)
#>   id type label x y
#> 1  1    a   one 6 1
#> 2  2    a   two 7 2
#> 3  3    b three 8 5
#> 4  4    b  four 9 6
}

