% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_cache.R
\name{set_cache}
\alias{set_cache}
\title{Cache a vector in the graph}
\usage{
set_cache(graph, to_cache, col = NULL)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{to_cache}{any vector or data frame.}

\item{col}{if a data frame is provided in
\code{to_cache} then a column name from that data
frame must provided here.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
Place any in the cache of a graph
object of class \code{dgr_graph}.
}
\examples{
# Create a random graph
graph <-
  create_random_graph(
    10, 22, set_seed = 1)

# Get the closeness values for all nodes from `1`
# to `10` and store in the graph's cache
graph <-
  graph \%>\%
  set_cache(get_closeness(.), "closeness")

# Get the graph's cache
get_cache(graph)
#> [1] 0.07142857 0.07692308 0.06666667 0.07142857
#> [5] 0.08333333 0.05882353 0.08333333 0.07692308
#> [9] 0.06666667 0.05882353

# Get the difference of betweenness and closeness
# values for nodes in the graph and store in the
# graph's cache
graph <-
  graph \%>\%
  set_cache(
    get_betweenness(.)$betweenness -
    get_closeness(.)$closeness)

# Get the graph's cache
get_cache(graph)
#> [1]  6.561905  5.561172  1.838095  3.947619
#> [5]  8.073810  1.941176 10.073810  8.780220
#> [9]  3.400000  1.107843
}

