% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_node_attr_w_fcn.R
\name{set_node_attr_w_fcn}
\alias{set_node_attr_w_fcn}
\title{Set node attribute values with a graph function}
\usage{
set_node_attr_w_fcn(graph, node_attr_fcn, ..., column_name = NULL)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{node_attr_fcn}{the name of the function to
use for creating a column of node attribute values.
Valid functions are: \code{get_alpha_centrality},
\code{get_authority_centrality},
\code{get_betweenness}, \code{get_bridging},
\code{get_closeness}, \code{get_cmty_edge_btwns},
\code{get_cmty_fast_greedy}, \code{get_cmty_l_eigenvec},
\code{get_cmty_louvain}, \code{get_cmty_walktrap},
\code{get_constraint}, \code{get_degree_distribution},
\code{get_degree_histogram}, \code{get_degree_in},
\code{get_degree_out}, \code{get_degree_total},
\code{get_eccentricity}, \code{get_eigen_centrality},
\code{get_pagerank}, \code{get_s_connected_cmpts},
and \code{get_w_connected_cmpts}.}

\item{...}{arguments and values to pass to
the named function in \code{node_attr_fcn}, if
necessary.}

\item{column_name}{an option to supply a column
name for the new node attribute column. If
\code{NULL} then the column name supplied by the
function will used along with a \code{__A}
suffix.}
}
\value{
either a graph object of class
\code{dgr_graph}.
}
\description{
From a graph object of class
\code{dgr_graph} or a node data frame, set node
attribute properties for all nodes in the graph
using one of several whole-graph functions.
}
\examples{
# Create a random graph
graph <-
  create_random_graph(
    n = 10, m = 22,
    set_seed = 23)

# Get the betweenness values for
# each of the graph's nodes as a
# node attribute
graph_1 <-
  graph \%>\%
  set_node_attr_w_fcn(
    node_attr_fcn = "get_betweenness")

# Inspect the graph's internal
# node data frame
graph_1 \%>\%
  get_node_df()
#>    id type label value betweenness__A
#> 1   1 <NA>     1   6.0       5.904762
#> 2   2 <NA>     2   2.5       4.904762
#> 3   3 <NA>     3   3.5       1.785714
#> 4   4 <NA>     4   7.5       0.000000
#> 5   5 <NA>     5   8.5       5.738095
#> 6   6 <NA>     6   4.5      20.523810
#> 7   7 <NA>     7  10.0       3.333333
#> 8   8 <NA>     8  10.0       0.000000
#> 9   9 <NA>     9   8.5       3.738095
#> 10 10 <NA>    10  10.0       4.071429

# If a specified function takes argument
# values, these can be supplied as well
graph_2 <-
  graph \%>\%
  set_node_attr_w_fcn(
    node_attr_fcn = "get_alpha_centrality",
    alpha = 2,
    exo = 2)

# Inspect the graph's internal
# node data frame
graph_2 \%>\%
  get_node_df()
#>    id type label value alpha_centrality__A
#> 1   1 <NA>     1   6.0                   2
#> 2   2 <NA>     2   2.5                   2
#> 3   3 <NA>     3   3.5                   6
#> 4   4 <NA>     4   7.5                   2
#> 5   5 <NA>     5   8.5                  14
#> 6   6 <NA>     6   4.5                  50
#> 7   7 <NA>     7  10.0                  22
#> 8   8 <NA>     8  10.0                 106
#> 9   9 <NA>     9   8.5                 162
#> 10 10 <NA>    10  10.0                 462

# The new column name can be provided
graph_3 <-
  graph \%>\%
  set_node_attr_w_fcn(
    node_attr_fcn = "get_pagerank",
    column_name = "pagerank")

# Inspect the graph's internal
# node data frame
graph_3 \%>\%
  get_node_df()
#>    id type label value   pagerank
#> 1   1 <NA>     1   6.0 0.04608804
#> 2   2 <NA>     2   2.5 0.04608804
#> 3   3 <NA>     3   3.5 0.05392301
#> 4   4 <NA>     4   7.5 0.04608804
#> 5   5 <NA>     5   8.5 0.07677500
#> 6   6 <NA>     6   4.5 0.11684759
#> 7   7 <NA>     7  10.0 0.07899491
#> 8   8 <NA>     8  10.0 0.08898857
#> 9   9 <NA>     9   8.5 0.16945368
#> 10 10 <NA>    10  10.0 0.27675311

# If `graph_3` is modified by
# adding a new node then the column
# `pagerank` will have stale data; we
# can run the function again and re-use
# the existing column name to provide
# updated values
graph_3 <-
  graph_3 \%>\%
  add_node(
    from = 1,
    to = 3,
    label = 11,
    value = 5.5) \%>\%
  set_node_attr_w_fcn(
    node_attr_fcn = "get_pagerank",
    column_name = "pagerank")

# Inspect the graph's internal
# node data frame
graph_3 \%>\%
  get_node_df()
#>    id type label value   pagerank
#> 1   1 <NA>     1   6.0 0.03943470
#> 2   2 <NA>     2   2.5 0.03943470
#> 3   3 <NA>     3   3.5 0.08535641
#> 4   4 <NA>     4   7.5 0.03943470
#> 5   5 <NA>     5   8.5 0.06401567
#> 6   6 <NA>     6   4.5 0.10870274
#> 7   7 <NA>     7  10.0 0.07702682
#> 8   8 <NA>     8  10.0 0.07693771
#> 9   9 <NA>     9   8.5 0.16659482
#> 10 10 <NA>    10  10.0 0.25692313
#> 11 11 <NA>    11   5.5 0.04613860
}
