% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_random_graph.R
\name{create_random_graph}
\alias{create_random_graph}
\title{Create a randomized graph}
\usage{
create_random_graph(n, m, directed = TRUE, graph_name = NULL,
  display_labels = TRUE, set_seed = NULL, write_backups = FALSE)
}
\arguments{
\item{n}{the number of nodes to use in the
random graph.}

\item{m}{the number of edges to use in the
random graph.}

\item{directed}{an option for whether the random
graph should be undirected (default) or directed.}

\item{graph_name}{an optional string for labeling
the graph object.}

\item{display_labels}{display node labels.}

\item{set_seed}{supplying a value sets a random seed
of the \code{Mersenne-Twister} implementation.}

\item{write_backups}{an option to write incremental
backups of changing graph states to disk. If
\code{TRUE}, a subdirectory of the working directory
will be used to store \code{RDS} files. The
default value is \code{FALSE} so one has to opt in
to use this functionality.}
}
\description{
Create a graph of up to \code{n} nodes
with randomized edge assignments.
}
\examples{
# Create a random, directed graph with 50 nodes
# and 75 edges
random_graph_directed <-
  create_random_graph(
    n = 50, m = 75)
}
