% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_pa_graph.R
\name{add_pa_graph}
\alias{add_pa_graph}
\title{Add a preferential attachment graph}
\usage{
add_pa_graph(graph, n, m = NULL, power = 1, out_dist = NULL,
  use_total_degree = FALSE, zero_appeal = 1, algo = "psumtree",
  type = NULL, label = TRUE, rel = NULL, node_aes = NULL,
  edge_aes = NULL, node_data = NULL, edge_data = NULL, set_seed = NULL)
}
\arguments{
\item{graph}{a graph object of
class \code{dgr_graph}.}

\item{n}{the number of nodes
comprising the preferential
attachment graph.}

\item{m}{the number of edges to
add in each time step.}

\item{power}{the power of the
preferential attachment. The
default value of \code{1}
indicates a linear preferential
attachment.}

\item{out_dist}{a numeric vector
that provides the distribution of
the number of edges to add in each
time step.}

\item{use_total_degree}{a logical
value (default is \code{TRUE})
that governs whether the total
degree should be used for
calculating the citation
probability. If \code{FALSE}, the
indegree is used.}

\item{zero_appeal}{a measure of
the attractiveness of the nodes
with no adjacent edges.}

\item{algo}{the algorithm to use
to generate the graph. The
available options are
\code{psumtree},
\code{psumtree-multiple}, and
\code{bag}. With the \code{psumtree}
algorithm, a partial prefix-sum
tree is used to to create the
graph. Any values for \code{power}
and \code{zero_appeal} can be
provided and this algorithm never
generates multiple edges.
The \code{psumtree-multiple}
algorithm also uses a partial
prefix-sum tree but the difference
here is that multiple edges are
allowed. The \code{bag} algorithm
places the node IDs into a bag as
many times as their in-degree
(plus once more). The required
number of cited nodes are drawn
from the bag with replacement.
Multiple edges may be produced
using this method (it is not
disallowed).}

\item{type}{an optional string that
describes the entity type for all the
nodes to be added.}

\item{label}{a boolean value where
setting to \code{TRUE} ascribes node
IDs to the label and \code{FALSE}
yields a blank label.}

\item{rel}{an optional string for
providing a relationship label to all
edges to be added.}

\item{node_aes}{an optional list
of named vectors comprising node
aesthetic attributes. The helper
function \code{node_aes()} is
strongly recommended for use here
as it contains arguments for each
of the accepted node aesthetic
attributes (e.g., \code{shape},
\code{style}, \code{color},
\code{fillcolor}).}

\item{edge_aes}{an optional list
of named vectors comprising edge
aesthetic attributes. The helper
function \code{edge_aes()} is
strongly recommended for use here
as it contains arguments for each
of the accepted edge aesthetic
attributes (e.g., \code{shape},
\code{style}, \code{penwidth},
\code{color}).}

\item{node_data}{an optional list
of named vectors comprising node
data attributes. The helper
function \code{node_data()} is
strongly recommended for use here
as it helps bind data specifically
to the created nodes.}

\item{edge_data}{an optional list
of named vectors comprising edge
data attributes. The helper function
\code{edge_data()} is strongly
recommended for use here as it helps
bind data specifically to the
created edges.}

\item{set_seed}{supplying a value
sets a random seed of the
\code{Mersenne-Twister}
implementation.}
}
\description{
To an existing graph
object, add a graph built
according to the Barabasi-Albert
model, which uses preferential
attachment in its stochastic
algorithm.
}
\examples{
# Create an undirected PA
# graph with 100 nodes, adding
# 2 edges at every time step
pa_graph <-
  create_graph(
    directed = FALSE) \%>\%
  add_pa_graph(
    n = 100,
    m = 1)

# Get a count of nodes
pa_graph \%>\%
  count_nodes()

# Get a count of edges
pa_graph \%>\%
  count_edges()
}
