% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_attr_dfs.R
\name{get_attr_dfs}
\alias{get_attr_dfs}
\title{Get data frames bound to node attributes}
\usage{
get_attr_dfs(graph, node_id = NULL, edge_id = NULL,
  return_format = "single_tbl")
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{node_id}{a vector of node ID values in
which data frames are bound as node attrs.}

\item{edge_id}{a vector of edge ID values in
which data frames are bound as edge attrs.}

\item{return_format}{the format in which to
return the results of several data frames. These
can either be: (1) \code{single_tbl} (a tibble
object resulting from a `bind_rows` operation of
multiple data frames), and (2) \code{single_df}
(a single data frame which all of the data frame
data).}
}
\value{
either a tibble or a data frame.
}
\description{
From a graph object of class
\code{dgr_graph}, get one or more data frames
already bound as node and/or edge attribute
values given graph node and/or edges.
}
\examples{
# Create a node data frame (ndf)
ndf <-
  create_node_df(
    n = 4,
    type = "basic",
    label = TRUE,
    value = c(3.5, 2.6, 9.4, 2.7))

# Create an edge data frame (edf)
edf <-
  create_edge_df(
    from = c(1, 2, 3),
    to = c(4, 3, 1),
    rel = "leading_to")

# Create a graph
graph <-
  create_graph(
    nodes_df = ndf,
    edges_df = edf)

# Create 3 simple data frames to add as
# attributes to nodes/edges
df_1 <-
  data.frame(
    a = c("one", "two"),
    b = c(1, 2),
    stringsAsFactors = FALSE)

df_2 <-
  data.frame(
    a = c("three", "four"),
    b = c(3, 4),
    stringsAsFactors = FALSE)

df_for_edges <-
  data.frame(
    c = c("five", "six"),
    d = c(5, 6),
    stringsAsFactors = FALSE)

# Bind data frames as node attributes
# for nodes `1` and `4`; bind a data
# frame as an edge attribute as well
graph <-
  graph \%>\%
  set_df_as_node_attr(
    node = 1,
    df = df_1) \%>\%
  set_df_as_node_attr(
    node = 4,
    df = df_2) \%>\%
  set_df_as_edge_attr(
    edge = 1,
    df = df_for_edges)

# Get a single tibble by specifying the
# nodes from which there are data frames
# bound as node attributes
get_attr_dfs(
  graph,
  node_id = c(1, 4))

# You can also get data frames that are
# associated with edges by using the
# same function
get_attr_dfs(
  graph,
  edge_id = 1)

# It's also possible to collect data frames
# associated with both nodes and edges
get_attr_dfs(
  graph,
  node_id = 4,
  edge_id = 1)

# If a data frame is desired instead,
# set `return_format = "single_df"`
get_attr_dfs(
  graph,
  edge_id = 1,
  return_format = "single_df")
}
