% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pagerank.R
\name{get_pagerank}
\alias{get_pagerank}
\title{Get the PageRank values for all nodes}
\usage{
get_pagerank(graph, directed = TRUE, damping = 0.85)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{directed}{if \code{TRUE} (the
default) then directed paths will
be considered for directed graphs.
This is ignored for undirected graphs.}

\item{damping}{the damping factor.
The default value is set to \code{0.85}.}
}
\value{
a data frame with PageRank
values for each of the nodes.
}
\description{
Get the PageRank
values for all nodes in the graph.
}
\examples{
# Create a random graph using the
# `add_gnm_graph()` function
graph <-
  create_graph() \%>\%
  add_gnm_graph(
    n = 10,
    m = 15,
    set_seed = 23)

# Get the PageRank scores
# for all nodes in the graph
graph \%>\%
  get_pagerank()

# Colorize nodes according to their
# PageRank scores
graph <-
  graph \%>\%
  join_node_attrs(
    df = get_pagerank(graph = .)) \%>\%
  colorize_node_attrs(
    node_attr_from = pagerank,
    node_attr_to = fillcolor,
    palette = "RdYlGn")
}
